/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.HessianFunction;
import com.numericalmethod.suanshu.analysis.function.matrix.RntoMatrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.optimization.unconstrained.hessian.GoldfeldQuandtTrotter;
import com.numericalmethod.suanshu.optimization.unconstrained.linesearch.Fletcher;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class NewtonRaphson
extends SteepestDescent {
    private RntoMatrix H;

    protected SteepestDescent.LineSearch getLineSearch() {
        return new NewtonRaphsonImpl(this.H);
    }

    public void solve(RealScalarFunction f, RealVectorFunction g2, double tol) {
        this.solve(f, g2, new HessianFunction(f), tol);
    }

    public void solve(RealScalarFunction f, RealVectorFunction g2, RntoMatrix H, double tol) {
        this.H = H;
        super.solve(f, g2, tol);
    }

    private class NewtonRaphsonImpl
    extends SteepestDescent.LineSearch {
        private final Fletcher H;

        private NewtonRaphsonImpl(RntoMatrix a2) {
            NewtonRaphsonImpl a3;
            super(a2);
            a3.H = new Fletcher(a3.NewtonRaphson.this.f, a3.NewtonRaphson.this.g);
        }

        public double minimize(Vector xk) {
            this.gk = NewtonRaphson.this.g.evaluate(xk.toArray());
            this.Hk = this.H.evaluate(xk.toArray());
            Matrix a2 = this.Hk.ONE();
            try {
                a2 = new Inverse(this.Hk);
            }
            catch (Exception a3) {
                try {
                    GoldfeldQuandtTrotter a4 = new GoldfeldQuandtTrotter(this.Hk, Double.POSITIVE_INFINITY);
                    a2 = new Inverse((Matrix)a4);
                }
                catch (Exception a5) {
                    a2 = this.Hk.ONE();
                }
            }
            this.dk = a2.multiply(this.gk);
            this.dk = this.dk.scaled(-1.0);
            double d2 = this.H.search(xk, this.dk);
            return d2;
        }
    }
}

