/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.GradientFunction;
import com.numericalmethod.suanshu.analysis.function.matrix.RntoMatrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedProblem;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public abstract class SteepestDescent
implements UnconstrainedMinimizer {
    protected double tol;
    protected RealScalarFunction f;
    private LineSearch m = null;
    private Vector H;
    protected RealVectorFunction g;

    public Vector search(int maxIterations, Vector ... initials) {
        int a2;
        SuanShuUtils.assertOrThrow(this.m != null ? null : new RuntimeException(b.C("t4Z|\u007fqAp|f}}9}tfquhvd4jt~4`z}4hpPz\u0016fAqQ|[}[1")));
        this.m.reset();
        Vector a3 = initials[0].deepCopy();
        double a4 = 1.0;
        int n = a2 = 1;
        while (n <= maxIterations) {
            a4 = this.m.minimize(a3);
            Vector a5 = this.m.dk.scaled(a4);
            a3 = a3.add(a5);
            if (a5.norm() <= this.tol) break;
            n = ++a2;
        }
        this.H = a3;
        return a3;
    }

    protected abstract LineSearch getLineSearch();

    public double minimum() {
        return this.f.evaluate(this.H.toArray());
    }

    public void solve(RealScalarFunction f, double tol) {
        this.solve(f, new GradientFunction(f), tol);
    }

    public void solve(RealScalarFunction f, RealVectorFunction g2, double tol) {
        this.f = f;
        this.g = g2;
        this.tol = tol;
        this.m = this.getLineSearch();
    }

    public void solve(UnconstrainedProblem problem, double tol) {
        this.solve(problem.f, tol);
    }

    public abstract class LineSearch {
        protected Vector dk = null;
        protected Matrix Hk = null;
        public final RntoMatrix H;
        protected Vector gk = null;

        protected LineSearch(RntoMatrix H) {
            this.H = H;
        }

        protected abstract double minimize(Vector var1);

        protected void reset() {
            this.gk = null;
            this.Hk = null;
            this.dk = null;
        }
    }
}

