/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;

public abstract class BracketSearch {
    int iter;
    double xnext;
    double xu;
    protected double tol;
    protected UnivariateRealFunction f;
    double fnext;
    double xmin;
    double fmin;
    double xl;

    abstract boolean isMinFound();

    public double search(int maxIterations, double lower, double initial, double upper) {
        if (initial <= lower && initial >= upper) {
            throw new IllegalArgumentException(b.C("|z`t}}v5\u007ff\u007fvrqn5lzrpsbc9"));
        }
        if (!this.isBracketing(lower, initial, upper)) {
            throw new IllegalArgumentException(b.C("a|s5xzfpob\u007fy9gjpf}`|dp\"xlm.{f`*wGuU~T`\u0012t\u001dyW{PyO8"));
        }
        this.xl = lower;
        this.xu = upper;
        this.xmin = initial;
        this.fmin = this.f.evaluate(this.xmin);
        int n = this.iter = 1;
        while (n <= maxIterations && !this.isMinFound()) {
            this.xnext = this.xnext();
            if (this.xnext <= this.xl || this.xnext >= this.xu) break;
            this.fnext = this.f.evaluate(this.xnext);
            this.updateStates();
            n = ++this.iter;
        }
        return 0.5 * (this.xl + this.xu);
    }

    abstract double xnext();

    void updateStates() {
        BracketSearch a2;
        if (a2.fnext < a2.fmin) {
            if (a2.xnext < a2.xmin) {
                a2.xu = a2.xmin;
            } else {
                a2.xl = a2.xmin;
            }
            a2.xmin = a2.xnext;
            a2.fmin = a2.fnext;
        } else if (a2.xnext < a2.xmin) {
            a2.xl = a2.xnext;
        } else {
            a2.xu = a2.xnext;
        }
    }

    boolean isBracketing(double a2, double a3, double a4) {
        BracketSearch a5;
        double a6 = a5.f.evaluate(a2);
        double a7 = a5.f.evaluate(a3);
        double a8 = a5.f.evaluate(a4);
        boolean a9 = false;
        if (a7 < a6 && a7 < a8) {
            a9 = true;
        }
        return a9;
    }

    public void solve(UnivariateRealFunction f, double tol) {
        this.f = f;
        double a2 = Math.sqrt(Constant.EPSILON);
        this.tol = tol < a2 ? a2 : tol;
    }

    public double minimum() {
        return this.fmin;
    }
}

