/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.univariate;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.optimization.univariate.BracketSearch;

public class Golden
extends BracketSearch {
    private final double H = 1.0 - 1.0 / Constant.GOLDEN_RATIO;

    public double search(int maxIterations, double lower, double upper) {
        double a2 = lower + this.H * (upper - lower);
        return super.search(maxIterations, lower, a2, upper);
    }

    boolean isMinFound() {
        Golden a2;
        return a2.xu - a2.xl < a2.tol;
    }

    double xnext() {
        Golden a2;
        double a3 = a2.xu - a2.xmin;
        double a4 = a2.xmin - a2.xl;
        double a5 = a2.xmin;
        a5 = a2.xmin + a2.H * (a3 > a4 ? a3 : -a4);
        return a5;
    }
}

