/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.parallel;

import com.numericalmethod.suanshu.parallel.IterationBody;
import com.numericalmethod.suanshu.parallel.LoopBody;
import com.numericalmethod.suanshu.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.parallel.SynchronizedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelExecutor {
    private final int H;

    public void conditionalForLoop(boolean conditionToParallelize, int start, int end, int increment, LoopBody body) throws MultipleExecutionException {
        if (conditionToParallelize) {
            this.forLoop(start, end, increment, body);
        } else {
            try {
                for (int a2 = start; a2 < end; a2 += increment) {
                    body.run(a2);
                }
            }
            catch (Exception a3) {
                Void[] voidArray = new Void[1];
                voidArray[0] = null;
                ExecutionException[] executionExceptionArray = new ExecutionException[1];
                executionExceptionArray[0] = new ExecutionException(a3);
                throw new MultipleExecutionException(Arrays.asList(voidArray), Arrays.asList(executionExceptionArray));
            }
        }
    }

    public <T> void conditionalForEach(boolean conditionToParallelize, Iterable<T> iterable, IterationBody<T> body) throws MultipleExecutionException {
        if (conditionToParallelize) {
            this.forEach(iterable, body);
        } else {
            Iterator<T> a2;
            Iterator<T> iterator = a2 = iterable.iterator();
            while (iterator.hasNext()) {
                T a3 = a2.next();
                body.run(a3);
                iterator = a2;
            }
        }
    }

    public <T> T executeAny(Callable<T> ... tasks) throws ExecutionException {
        return this.executeAny(Arrays.asList(tasks));
    }

    public <T> List<T> executeAll(Callable<T> ... tasks) throws MultipleExecutionException {
        return this.executeAll(Arrays.asList(tasks));
    }

    public void conditionalForLoop(boolean conditionToParallelize, int start, int end, LoopBody body) throws MultipleExecutionException {
        this.conditionalForLoop(conditionToParallelize, start, end, 1, body);
    }

    public ParallelExecutor() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public <T> List<T> executeAll(List<? extends Callable<T>> tasks) throws MultipleExecutionException {
        ExecutorService a2 = Executors.newFixedThreadPool(this.H);
        ArrayList a3 = new ArrayList(tasks.size());
        try {
            List a4 = a2.invokeAll(tasks);
            ArrayList<ExecutionException> a5 = new ArrayList<ExecutionException>(a4.size());
            boolean a6 = false;
            for (Future a7 : a4) {
                try {
                    a3.add(a7.get());
                    a5.add(null);
                }
                catch (ExecutionException a8) {
                    a3.add(null);
                    a5.add(a8);
                    a6 = true;
                }
            }
            if (a6) {
                throw new MultipleExecutionException(a3, a5);
            }
        }
        catch (InterruptedException a9) {
            throw new RuntimeException(a9);
        }
        finally {
            a2.shutdown();
        }
        return a3;
    }

    public void forLoop(int start, int end, final int increment, final LoopBody body) throws MultipleExecutionException {
        int a2;
        int a3;
        ArrayList<1> a4 = new ArrayList<1>(this.H);
        int a5 = (int)Math.ceil((double)((end - start) / increment) / (double)this.H) * increment;
        a5 = Math.max(1, a5);
        int n = a3 = 0;
        while (n < this.H && (a2 = start + a3 * a5) < end) {
            final int a6 = Math.min(a2 + a5, end);
            a4.add(new Callable<Void>(){
                {
                    1 a22;
                }

                @Override
                public Void call() throws Exception {
                    int a22;
                    int n = a22 = a2;
                    while (n < a6) {
                        body.run(a22);
                        n = a22 + increment;
                    }
                    return null;
                }
            });
            n = ++a3;
        }
        this.executeAll(a4);
    }

    public <T> T executeAny(List<? extends Callable<T>> tasks) throws ExecutionException {
        ExecutorService a2 = Executors.newCachedThreadPool();
        T a3 = null;
        try {
            a3 = a2.invokeAny(tasks);
        }
        catch (InterruptedException a4) {
            throw new RuntimeException(a4);
        }
        finally {
            a2.shutdown();
        }
        return a3;
    }

    public ParallelExecutor(int concurrency) {
        this.H = concurrency;
    }

    public <T> void forEach(Iterable<T> iterable, final IterationBody<T> body) throws MultipleExecutionException {
        int a2;
        ArrayList<2> a3 = new ArrayList<2>(this.H);
        final SynchronizedIterator<T> a4 = new SynchronizedIterator<T>(iterable.iterator());
        int n = a2 = 0;
        while (n < this.H) {
            a3.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SynchronizedIterator.Element a2;
                    2 v0 = this;
                    while ((a2 = v0.a4.next()).exists()) {
                        body.run(a2.get());
                        v0 = this;
                    }
                    return null;
                }
                {
                    2 a2;
                }
            });
            n = ++a2;
        }
        this.executeAll(a3);
    }

    public void forLoop(int start, int end, LoopBody body) throws MultipleExecutionException {
        this.forLoop(start, end, 1, body);
    }
}

