/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.signalprocessing;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;
import com.numericalmethod.suanshu.stats.random.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.distribution.Gaussian;
import com.numericalmethod.suanshu.stats.random.distribution.InverseTransformSampling;
import com.numericalmethod.suanshu.stats.random.multivariate.IID;
import com.numericalmethod.suanshu.stats.random.pseudorandom.MersenneTwister;
import java.util.Arrays;

public class Innovations {
    private double[] H;

    public Innovations(int length, UnivariateDistribution dist, double mu, double var) {
        this(length, dist, mu, var, -1L);
    }

    private void H(double[] a2) {
        a.H = Arrays.copyOf(a2, a2.length);
    }

    public Innovations(int length, double mu, double var) {
        this(length, mu, var, -1);
    }

    public double[] toArray(int length) {
        SuanShuUtils.assertArgument(length <= this.H.length, b.C("a|sgt4sgx4pzm4\u007f{jaa}!}l{bboa`{d&"));
        return Arrays.copyOf(this.H, this.H.length);
    }

    public Innovations(int length, UnivariateDistribution dist) {
        this(length, dist, 0.0, 1.0, -1L);
    }

    public Innovations(int length, UnivariateDistribution dist, double mu, double var, long seed) {
        int a2;
        double[] a3 = new double[length];
        MersenneTwister a4 = new MersenneTwister();
        if (seed > 0L) {
            long[] lArray = new long[1];
            lArray[0] = seed;
            a4.seed(lArray);
        }
        InverseTransformSampling a5 = new InverseTransformSampling(dist, a4);
        double a6 = dist.mean();
        double a7 = dist.variance();
        int n = a2 = 0;
        while (n < length) {
            a3[a2] = (a5.nextDouble() - a6 + mu) * Math.sqrt(var / a7);
            n = ++a2;
        }
        this.H(a3);
    }

    public Innovations(double[] innovations) {
        this.H(innovations);
    }

    public Innovations(int length, RandomNumberGenerator rng, int seed) {
        if (seed > 0) {
            long[] lArray = new long[1];
            lArray[0] = seed;
            rng.seed(lArray);
        }
        double[] a2 = new IID(rng, length).nextVector();
        this.H(a2);
    }

    public Innovations(int length, RandomNumberGenerator rng) {
        this(length, rng, -1);
    }

    public Innovations(Innovations innovation) {
        this.H(innovation.H);
    }

    public Innovations(int length, double mu, double var, int seed) {
        this(length, new Gaussian(mu, Math.sqrt(var)), seed);
    }

    public Innovations(int length) {
        this(length, 0.0, 1.0, -1);
    }

    public double[] toArray() {
        return this.toArray(this.H.length);
    }
}

