/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.cointegration;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.Cholesky;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixMathImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.cointegration.AuxiliaryRegression1;
import com.numericalmethod.suanshu.stats.cointegration.AuxiliaryRegression2;
import com.numericalmethod.suanshu.stats.cointegration.JohansenAsymptoticDistribution;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.SimpleMultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class CointegrationMle {
    private final Vector G;
    public final JohansenAsymptoticDistribution.Test test;
    public final boolean intercept;
    private final DenseMatrix M;
    private final Matrix m;
    private final double[] H;

    public CointegrationMle(SimpleMultiVariateTimeSeries ts, boolean intercept, int p2, Matrix D, JohansenAsymptoticDistribution.Test test) {
        int a2;
        int a3;
        SuanShuUtils.assertArgument(p2 >= 1, b.C("d5))0d"));
        this.intercept = intercept;
        this.test = test;
        int a4 = ts.dimension();
        int a5 = ts.size();
        int n = D == null ? 0 : (a3 = D.nCols());
        SuanShuUtils.assertArgument(D == null || D.nRows() == a5, b.C("P5vzt5g|y5ratarbegnutp#`exj4{py}Qf\u0017p_5]{H5WuNp\u001b`Lp\u0007gAxF4B`BvMg\u000b{r5e{g&"));
        int a6 = a5 - p2;
        int a7 = a4 * (p2 - 1) + a3 + (intercept ? 1 : 0);
        SuanShuUtils.assertArgument(a5 - p2 > a7 + p2 * (p2 + 1) / 2, b.C("a|s5|a~atb\u007fgpunp%`oxd4qp\u007f}kf)pepF4XzE4ZtKq\u001epW{OrM4H`LvGg\r{H5[{]&"));
        AuxiliaryRegression1 a8 = new AuxiliaryRegression1(ts, p2, D, intercept);
        AuxiliaryRegression2 a9 = new AuxiliaryRegression2(ts, p2, D, intercept);
        ImmutableMatrix a10 = a8.errors();
        ImmutableMatrix a11 = a9.errors();
        Matrix a12 = a10.t().multiply(a10).scaled(1.0 / (double)a6);
        Matrix a13 = a10.t().multiply(a11).scaled(1.0 / (double)a6);
        Matrix a14 = a13.t();
        Matrix a15 = a11.t().multiply(a11).scaled(1.0 / (double)a6);
        LowerTriangularMatrix a16 = new Cholesky(a15).L();
        Inverse a17 = new Inverse(a16);
        Matrix a18 = a17.multiply(a14).multiply(new Inverse(a12)).multiply(a13).multiply(a17.t());
        Eigen a19 = new Eigen(a18);
        this.G = new DenseVector(a19.realEigenvalues());
        int a20 = this.G.size();
        this.M = new DenseMatrix(a4, a20);
        this.H = new double[a20];
        int n2 = a2 = 0;
        while (n2 < a20) {
            Eigen.Property a21 = a19.getProperty(a2);
            if (test == JohansenAsymptoticDistribution.Test.EIGEN) {
                this.H[a2] = (double)(-a6) * Math.log(1.0 - a21.eigenvalue().doubleValue());
            } else if (a2 == 0) {
                this.H[a20 - a2 - 1] = (double)(-a6) * Math.log(1.0 - a19.getProperty(a20 - a2 - 1).eigenvalue().doubleValue());
            } else {
                this.H[a20 - a2 - 1] = Math.log(1.0 - a19.getProperty(a20 - a2 - 1).eigenvalue().doubleValue());
                int n3 = a20 - a2 - 1;
                this.H[n3] = this.H[n3] * (double)(-a6);
                int n4 = a20 - a2 - 1;
                this.H[n4] = this.H[n4] + this.H[a20 - a2];
            }
            Vector a22 = a17.t().multiply(a21.eigenVector());
            a22 = a22.scaled(1.0 / a22.get(1));
            this.M.setColumn(a2 + 1, a22);
            n2 = ++a2;
        }
        this.m = a13.multiply(this.M).multiply(new Inverse(((MatrixMathImpl)this.M.t()).multiply(a15).multiply(this.M)));
    }

    public ImmutableVector beta(int r) {
        return new ImmutableVector(this.M.getColumn(r));
    }

    public ImmutableVector getStats() {
        return new ImmutableVector(new DenseVector(this.H));
    }

    public CointegrationMle(SimpleMultiVariateTimeSeries ts, boolean intercept, int p2) {
        this(ts, intercept, p2, null, JohansenAsymptoticDistribution.Test.EIGEN);
    }

    public ImmutableMatrix beta() {
        return new ImmutableMatrix(this.M);
    }

    public ImmutableMatrix alpha() {
        return new ImmutableMatrix(this.m);
    }

    public ImmutableVector eigenvalues() {
        return new ImmutableVector(this.G);
    }

    public CointegrationMle(SimpleMultiVariateTimeSeries ts, boolean intercept) {
        this(ts, intercept, 2);
    }
}

