/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.cointegration;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.matrix.doubles.operation.Measure;
import com.numericalmethod.suanshu.stats.cointegration.JohansenAsymptoticDistribution;
import com.numericalmethod.suanshu.stats.descriptive.rank.Max;
import com.numericalmethod.suanshu.stats.stochasticprocess.timepoints.EvenlySpacedGrid;
import com.numericalmethod.suanshu.stats.stochasticprocess.timepoints.TimeGrid;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.Realization;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.brownian.RandomWalk;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.Filtration;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.FiltrationFunction;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.IntegralDB;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.IntegralDt;
import com.numericalmethod.suanshu.stats.stochasticprocess.univariate.integration.sde.Construction;

public class JohansenAsymptoticDistributionSimulation {
    private final JohansenAsymptoticDistribution.Test F;
    private final int B;
    private final F G;
    private final Construction M;
    private final int m;
    private final TimeGrid H;

    public double[] simulation() {
        int a2;
        double[] a3 = new double[this.B];
        int n = a2 = 0;
        while (n < this.B) {
            double a4;
            int a5;
            Realization[] a6 = new Realization[this.m];
            int n2 = a5 = 0;
            while (n2 < this.m) {
                a6[a5] = this.M.realization(0.0);
                n2 = ++a5;
            }
            FiltrationFunction[] a22 = this.G.evaluate(a6);
            DenseMatrix a7 = this.H(a6, a22);
            DenseMatrix a8 = this.H(a22);
            a3[a2] = a4 = this.H(this.F, a7, a8);
            n = ++a2;
        }
        return a3;
    }

    private DenseMatrix H(Realization[] a2, FiltrationFunction[] a3) {
        int a4;
        int a5 = a2.length;
        int a6 = a3.length;
        DenseMatrix a7 = new DenseMatrix(a5, a6);
        int n = a4 = 0;
        while (n < a5) {
            int a8;
            Filtration a9 = new Filtration(a2[a4]);
            int n2 = a8 = 0;
            while (n2 < a6) {
                double a10 = new IntegralDB(a3[a8]).integral(a9);
                a7.set(a4 + 1, a8 + 1, a10);
                n2 = ++a8;
            }
            n = ++a4;
        }
        return a7;
    }

    private double H(JohansenAsymptoticDistribution.Test a2, Matrix a3, Matrix a4) {
        Matrix a5 = a3.multiply(new Inverse(a4)).multiply(a3.t());
        switch (a2) {
            case EIGEN: {
                double[] a6 = new Eigen(a5).realEigenvalues();
                Max a7 = new Max(a6);
                return a7.value();
            }
            case TRACE: {
                do {
                } while (false);
                return Measure.tr(a5);
            }
        }
        throw new RuntimeException(b.C("MP[\\JY\u001aNEYUTWE\u0012\\\rJOQ@X\nI@OR\u001dRLG^tZw^xHsR;"));
    }

    public JohansenAsymptoticDistributionSimulation(JohansenAsymptoticDistribution.Test test, F F2, int dr, long seed, int nSim, int nT) {
        this.F = test;
        this.G = F2;
        this.m = dr;
        this.B = nSim;
        this.H = new EvenlySpacedGrid(0.0, 1.0, nT);
        this.M = new RandomWalk(this.H);
        this.M.seed(seed);
    }

    private DenseMatrix H(FiltrationFunction[] a2) {
        int a3;
        int a4 = a2.length;
        DenseMatrix a5 = new DenseMatrix(a4, a4);
        int n = a3 = 0;
        while (n < a4) {
            int a6;
            int n2 = a6 = 0;
            while (n2 < a4) {
                JohansenAsymptoticDistributionSimulation a7;
                final FiltrationFunction a8 = a2[a3];
                final FiltrationFunction a9 = a2[a6];
                FiltrationFunction a10 = new FiltrationFunction(){

                    public void setFT(Filtration FT) {
                        super.setFT(FT);
                    }
                    {
                        1 a2;
                    }

                    public double evaluate(int t2) {
                        double a2 = a8.evaluate(t2);
                        double a3 = a9.evaluate(t2);
                        return a2 * a3;
                    }
                };
                double a11 = new IntegralDt(a10).integral(new Filtration(a7.M.realization(0.0)));
                a5.set(a3 + 1, a6 + 1, a11);
                n2 = ++a6;
            }
            n = ++a3;
        }
        return a5;
    }

    public static interface F {
        public FiltrationFunction[] evaluate(Realization[] var1);
    }
}

