/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.cointegration;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.cointegration.CointegrationMle;
import com.numericalmethod.suanshu.stats.cointegration.JohansenAsymptoticDistribution;
import com.numericalmethod.suanshu.stats.random.RNG;

public class JohansenTest {
    private final JohansenAsymptoticDistribution.TrendType M;
    private final JohansenAsymptoticDistribution.Test m;
    private final JohansenAsymptoticDistribution[] H;

    public JohansenTest(JohansenAsymptoticDistribution.Test test, JohansenAsymptoticDistribution.TrendType trend, int dim, int nSim, int nT) {
        int a2;
        this.m = test;
        this.M = trend;
        this.H = new JohansenAsymptoticDistribution[dim];
        int n = a2 = 0;
        while (n < dim) {
            this.H[a2] = new JohansenAsymptoticDistribution(test, trend, dim - a2, new RNG().nextLong(), dim - a2 <= 2 ? Math.max(5000, nSim) : nSim, nT);
            n = ++a2;
        }
    }

    public JohansenTest(JohansenAsymptoticDistribution.Test test, JohansenAsymptoticDistribution.TrendType trend, int dim) {
        this(test, trend, dim, 500, 500);
    }

    public int r(CointegrationMle cointegrationMle, double level) {
        int a2;
        Object[] objectArray = new Object[1];
        objectArray[0] = this.m.toString();
        SuanShuUtils.assertArgument(cointegrationMle.test == this.m, String.format(b.C("JWTM\u001a\u0003MJ\buZVSQB[@kHM^\u0003\u0006JR\u0001\u0005JGLU\u001eqQqG:YvL6\u001a&"), objectArray));
        double a3 = 1.0 - level;
        double[] a4 = cointegrationMle.getStats().toArray();
        int n = a2 = 0;
        while (n < a4.length && !(a4[a2] < this.H[a2].quantile(a3))) {
            n = ++a2;
        }
        return a2;
    }

    public JohansenTest(CointegrationMle cointegrationMle) {
        this(cointegrationMle.test, JohansenAsymptoticDistribution.TrendType.RESTRICTED_CONSTANT, cointegrationMle.getStats().size());
    }
}

