/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;

public class Covariance
implements Statistic {
    private Variance F;
    private Mean B;
    private long G = 0L;
    private Mean M = new Mean();
    private double m = 0.0;
    private Variance H = new Variance();

    public Covariance(Covariance that) {
        this.B = new Mean();
        this.F = new Variance();
        this.G = that.G;
        this.M = that.M;
        this.H = that.H;
        this.B = that.B;
        this.F = that.F;
        this.m = that.m;
    }

    public void addData(double ... data) {
        SuanShuUtils.assertArgument(data.length % 2 == 0, b.C("JWXL_\u001fTKEK\u0015\\W\u001fPP\u000eZ[[D\u001fGKK]@L\u0002PG\u001ez^i_:OvWxK&"));
        double[][] a2 = new double[2][data.length / 2];
        int a3 = 0;
        int a4 = 0;
        int n = a3;
        while (true) {
            if (n >= data.length / 2) break;
            a2[0][a4] = data[a3];
            ++a4;
            n = ++a3;
        }
        a4 = 0;
        int n2 = a3;
        while (n2 < data.length) {
            a2[1][a4] = data[a3];
            ++a4;
            n2 = ++a3;
        }
        this.addData(a2);
    }

    public double value() {
        return this.G > 1L ? this.m / (double)(this.G - 1L) : Double.NaN;
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.value();
        objectArray[1] = this.correlation();
        objectArray[2] = this.G;
        return String.format(b.C("wzaub|rz\u007fp%4=s 4gzufeyb`eza.(0m8\u0014[\r4\u00151"), objectArray);
    }

    public long N() {
        return this.G;
    }

    public double correlation() {
        return this.value() / this.H.standardDeviation() / this.F.standardDeviation();
    }

    public Covariance(double[][] data) {
        this.B = new Mean();
        this.F = new Variance();
        this.addData(data);
    }

    public Covariance() {
        this.B = new Mean();
        this.F = new Variance();
    }

    public void addData(double[][] data) {
        SuanShuUtils.assertArgument(data.length == 2, b.C("a|sgt4\u007f`n`>w|4{5uuog!{d5iuz4"));
        SuanShuUtils.assertArgument(data[0].length == data[1].length, b.C("NS\\H[\u001bPOAO\u0011XS\u001bT\u001aZZ@H\u000eTK\u001aFZU[\u0006TC\u001anS|\u001amZp_2WtTqO="));
        if (this.G == 0L) {
            int a2;
            this.G = data[0].length;
            this.M.addData(data[0]);
            this.H.addData(data[0]);
            this.B.addData(data[1]);
            this.F.addData(data[1]);
            double a3 = this.M.value();
            double a4 = this.B.value();
            this.m = 0.0;
            int n = a2 = 0;
            while ((long)n < this.G) {
                this.m += (data[0][a2] - a3) * (data[1][a2] - a4);
                n = ++a2;
            }
            return;
        }
        Covariance a5 = new Covariance(data);
        long a6 = this.G + a5.G;
        double a7 = a5.M.value() - this.M.value();
        double a8 = a5.B.value() - this.B.value();
        double a9 = (double)this.G / (double)a6 * (double)a5.G;
        this.m += a5.m + (a9 *= a7 * a8);
        this.M.addData(data[0]);
        this.B.addData(data[1]);
        this.G = a6;
    }
}

