/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.stats.descriptive.Covariance;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class CovarianceMatrix
extends DenseMatrix {
    public CovarianceMatrix(Matrix A) {
        super(A.nCols(), A.nCols());
        int a2;
        int n = a2 = 1;
        while (n <= A.nCols()) {
            int n2 = a2;
            while (n2 <= A.nCols()) {
                int a3;
                int a4;
                int a5;
                double[] a6 = new double[A.nRows()];
                int n3 = a5 = 1;
                while (n3 <= A.nRows()) {
                    a6[a5 - 1] = A.get(a5, a2);
                    n3 = ++a5;
                }
                double[] a22 = new double[A.nRows()];
                int n4 = a4 = 1;
                while (n4 <= A.nRows()) {
                    a22[a4 - 1] = A.get(a4, a3);
                    n4 = ++a4;
                }
                double[][] dArrayArray = new double[2][];
                dArrayArray[0] = a6;
                dArrayArray[1] = a22;
                Covariance a32 = new Covariance(dArrayArray);
                super.set(a2, a3, a32.value());
                super.set(a3, a2, a32.value());
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    public ImmutableMatrix correlationMatrix() {
        int a2;
        Vector a3 = CreateVector.diagonal(this);
        DenseMatrix a4 = new DenseMatrix(this);
        int n = a2 = 1;
        while (n <= this.nCols()) {
            int n2 = a2;
            while (n2 <= this.nRows()) {
                int a5;
                a4.set(a2, a5, this.get(a2, a5) / Math.sqrt(a3.get(a2)) / Math.sqrt(a3.get(a5)));
                a4.set(a5, a2, this.get(a2, a5) / Math.sqrt(a3.get(a2)) / Math.sqrt(a3.get(a5)));
                n2 = ++a5;
            }
            n = ++a2;
        }
        return new ImmutableMatrix(a4);
    }
}

