/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.moment;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import java.util.Arrays;

public class Moments
implements Statistic {
    public final int order;
    private double[] m;
    private long H = 0L;

    public Moments(int order) {
        this.order = order;
        this.m = new double[order];
    }

    public Moments(Moments that) {
        this.order = that.order;
        this.H = that.H;
        this.m = Arrays.copyOf(that.m, that.m.length);
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        int n = a2 = 0;
        while (n < this.m.length) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a2;
            objectArray[1] = this.m[a2];
            a3.append(String.format(b.C("sD8zG%9;p$u"), objectArray));
            n = ++a2;
        }
        return a3.toString();
    }

    public double value() {
        return this.centralMoment(this.order);
    }

    public void addData(double ... data) {
        int a2;
        if (this.H == 0L) {
            int a3;
            this.H = data.length;
            this.m[0] = Moments.sumsOfPowersOfDifferences(1, 0.0, data);
            double a4 = this.m[0] / (double)this.H;
            int n = a3 = 2;
            while (n <= this.order) {
                this.m[a3 - 1] = Moments.sumsOfPowersOfDifferences(a3, a4, data);
                n = ++a3;
            }
            return;
        }
        Moments a5 = new Moments(this);
        Moments a6 = new Moments(this.order, data);
        long a7 = a5.H + a6.H;
        double a8 = a6.m[0] / (double)a6.H - a5.m[0] / (double)a5.H;
        this.m[0] = a5.m[0] + a6.m[0];
        int n = a2 = 2;
        while (n <= this.order) {
            int a9;
            double a10 = 0.0;
            int n2 = a9 = 1;
            while (true) {
                if (n2 > a2 - 2) break;
                int a11 = a2 - a9;
                double a12 = Math.pow((double)(-a6.H) / (double)a7, a9) * a5.m[a11 - 1];
                a12 += Math.pow((double)a5.H / (double)a7, a9) * a6.m[a11 - 1];
                a12 *= Math.pow(a8, a9);
                a10 += (a12 *= FunctionOps.combination(a2, a9));
                n2 = ++a9;
            }
            double a22 = (double)a5.H / (double)a7;
            a22 *= a8 * (double)a6.H;
            a22 = Math.pow(a22, a2);
            a22 *= 1.0 / Math.pow(a6.H, a2 - 1) - Math.pow(-1.0 / (double)a5.H, a2 - 1);
            this.m[a2 - 1] = a5.m[a2 - 1] + a6.m[a2 - 1] + a10 + a22;
            n = ++a2;
        }
        this.H = a7;
    }

    static double sumsOfPowersOfDifferences(int a2, double a3, double ... a4) {
        int a5;
        double a6 = 0.0;
        double[] a7 = a4;
        int a8 = a4.length;
        int n = a5 = 0;
        while (n < a8) {
            double a9 = a7[a5] - a3;
            a6 += a2 == 1 ? a9 : Math.pow(a9, a2);
            n = ++a5;
        }
        return a6;
    }

    public long N() {
        return this.H;
    }

    public double centralMoment(int k2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.order;
        SuanShuUtils.assertArgument(k2 <= this.order, String.format(b.C("{{{m0`c4hz?`pp;1`5j{mpm`,t}q(t}u]yVv\\0"), objectArray));
        return this.m[k2 - 1] / (double)this.H;
    }

    public Moments(int order, double ... data) {
        this(order);
        this.addData(data);
    }
}

