/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.moment;

import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import com.numericalmethod.suanshu.stats.descriptive.moment.Moments;

public class Skewness
implements Statistic {
    private Moments M = new Moments(2);
    private long m = 0L;
    private double H = 0.0;

    public double sample() {
        double a2 = this.M.centralMoment(2);
        return this.H / (double)this.m / Math.pow(a2, 1.5);
    }

    public long N() {
        return this.m;
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.value();
        objectArray[1] = this.m;
        return String.format(b.C("ip|m$;8|);_ 6>1"), objectArray);
    }

    public double value() {
        double a2 = this.H() / (double)(this.m - 1L);
        return this.m >= 2L ? this.H / (double)this.m / Math.pow(a2, 1.5) : 0.0;
    }

    public Skewness(double[] data) {
        this.addData(data);
    }

    private double C() {
        Skewness a2;
        return a2.M.centralMoment(1);
    }

    private double H() {
        Skewness a2;
        return a2.M.centralMoment(2) * (double)a2.M.N();
    }

    public Skewness() {
    }

    public Skewness(Skewness that) {
        this.m = that.m;
        this.M = new Moments(that.M);
        this.H = that.H;
    }

    public void addData(double ... data) {
        if (this.m == 0L) {
            this.m = data.length;
            this.M.addData(data);
            this.H = Moments.sumsOfPowersOfDifferences(3, this.M.centralMoment(1), data);
            return;
        }
        Skewness a2 = new Skewness(data);
        double a3 = a2.C() - this.C();
        double a4 = this.H();
        double a5 = a2.H();
        long a6 = this.m + a2.m;
        double a7 = 3.0 * a3 * ((double)this.m * a5 - (double)a2.m * a4) / (double)a6;
        double a8 = (double)this.m / (double)a6;
        a8 *= a3 * (double)a2.m;
        a8 = a8 * a8 * a8;
        this.H += a2.H + a7 + (a8 *= 1.0 / (double)a2.m / (double)a2.m - 1.0 / (double)this.m / (double)this.m);
        this.M.addData(data);
        this.m = a6;
    }
}

