/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.moment;

import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Moments;

public class Variance
implements Statistic {
    public final boolean unbiased;
    private Mean M = new Mean();
    private double m = 0.0;
    private long H = 0L;

    public double value() {
        return this.H >= 2L ? this.m / (double)(this.unbiased ? this.H - 1L : this.H) : 0.0;
    }

    public Variance(double[] data, boolean unbiased) {
        this.unbiased = unbiased;
        this.addData(data);
    }

    public Variance(Variance that) {
        this.unbiased = that.unbiased;
        this.H = that.H;
        this.m = that.m;
        this.M = new Mean(that.M);
    }

    public long N() {
        return this.H;
    }

    public Variance() {
        this.unbiased = true;
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.value();
        objectArray[1] = this.standardDeviation();
        objectArray[2] = this.H;
        return String.format(b.C("{m|7))l!%\u007fridz8-8j2-W6:(1"), objectArray);
    }

    public void addData(double ... data) {
        if (this.H == 0L) {
            this.H = data.length;
            this.M.addData(data);
            this.m = Moments.sumsOfPowersOfDifferences(2, this.M.value(), data);
            return;
        }
        Variance a2 = new Variance(data, this.unbiased);
        double a3 = a2.M.value() - this.M.value();
        long a4 = this.H + a2.H;
        this.m += a2.m + a3 * a3 * ((double)this.H / (double)a4) * (double)a2.H;
        this.M.addData(data);
        this.H = a4;
    }

    public Variance(double[] data) {
        this.unbiased = true;
        this.addData(data);
    }

    public double standardDeviation() {
        return Math.sqrt(this.value());
    }
}

