/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.descriptive.rank;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.descriptive.Statistic;
import java.util.Arrays;

public class Quantile
implements Statistic {
    public final Type type;
    private double[] H;

    private int H(double a2, double a3) {
        Quantile a4;
        int a5 = a4.H.length;
        int a6 = (int)Math.floor(a2 * (double)a5 + a3);
        a6 = a6 > 0 ? a6 : 0;
        a6 = a6 <= a5 ? a6 : a5;
        return a6;
    }

    private double C(double a2, double a3, double a4) {
        return a3 + a2 * (1.0 - a3 - a4);
    }

    private double H(double a2, int a3) {
        Quantile a4;
        double a5 = (1.0 - a2) * a4.H[a3 > 0 ? a3 - 1 : 0];
        return a5 += a2 * a4.H[a3 < a4.H.length ? a3 : a4.H.length - 1];
    }

    private double H(double a2, double a3, double a4) {
        Quantile a5;
        int a6 = a5.H.length;
        return a2 * (double)a6 + a3 - a4;
    }

    public double value(double q) {
        Object[] objectArray = new Object[1];
        objectArray[0] = q;
        SuanShuUtils.assertArgument(q > 0.0 && q <= 1.0, String.format(b.C("$5+4a5/)<$$4q{kap5:4%3"), objectArray));
        int a2 = 0;
        double a3 = 0.0;
        double a4 = 0.0;
        double a5 = 0.0;
        double a6 = 0.0;
        switch (this.type) {
            case INVERSE_OF_EMPIRICAL_CDF: {
                a3 = 0.0;
                a2 = this.H(q, a3);
                a4 = this.H(q, a3, a2);
                a5 = DoubleUtils.compare(a4, 0.0) == 0 ? 0.0 : 1.0;
                break;
            }
            case INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES: {
                a3 = 0.0;
                a2 = this.H(q, a3);
                a4 = this.H(q, a3, a2);
                a5 = DoubleUtils.compare(a4, 0.0) == 0 ? 0.5 : 1.0;
                break;
            }
            case NEAREST_EVEN_ORDER_STATISTICS: {
                a3 = -0.5;
                a2 = this.H(q, a3);
                a4 = this.H(q, a3, a2);
                a5 = DoubleUtils.compare(a4, 0.0) == 0 ? (a2 % 2 == 0 ? 0.0 : 1.0) : 1.0;
                break;
            }
            case LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF: {
                a3 = 0.0;
                a2 = this.H(q, a3);
                a5 = a4 = this.H(q, a3, a2);
                break;
            }
            case MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF: {
                a3 = 0.5;
                a2 = this.H(q, a3);
                a5 = a4 = this.H(q, a3, a2);
                break;
            }
            case MINITAB_SPSS: {
                a3 = q;
                a2 = this.H(q, a3);
                a5 = a4 = this.H(q, a3, a2);
                break;
            }
            case S: {
                a3 = 1.0 - q;
                a2 = this.H(q, a3);
                a5 = a4 = this.H(q, a3, a2);
                break;
            }
            case APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL: {
                do {
                } while (false);
                a3 = this.C(q, 0.375, 0.375);
                a2 = this.H(q, a3);
                a5 = a4 = this.H(q, a3, a2);
                break;
            }
            default: {
                a3 = this.C(q, 0.3333333333333333, 0.3333333333333333);
                a2 = this.H(q, a3);
                a5 = a4 = this.H(q, a3, a2);
            }
        }
        a6 = this.H(a5, a2);
        return a6;
    }

    public void addData(double ... data) {
        int a2;
        int a3;
        int n = this.H == null ? 0 : (a3 = this.H.length);
        this.H = this.H == null ? new double[data.length] : Arrays.copyOf(this.H, this.H.length + data.length);
        int n2 = a2 = 0;
        while (n2 < data.length) {
            this.H[a3 + a2] = data[a2];
            n2 = ++a2;
        }
        Arrays.sort(this.H);
    }

    public Quantile(double[] data) {
        this(data, Type.APPROXIMATELY_MEDIAN_UNBIASED);
    }

    public Quantile(double[] data, Type type) {
        this.type = type;
        this.addData(data);
    }

    public long N() {
        return this.H.length;
    }

    public double value() {
        throw new UnsupportedOperationException(b.C("mzb4}```<fjdhyb4e5vaa{w}`p/biy~q\u0014$"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF;
        private static final /* synthetic */ Type[] $VALUES;
        public static final /* enum */ Type APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL;
        public static final /* enum */ Type INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES;
        public static final /* enum */ Type INVERSE_OF_EMPIRICAL_CDF;
        public static final /* enum */ Type MINITAB_SPSS;
        public static final /* enum */ Type S;
        public static final /* enum */ Type APPROXIMATELY_MEDIAN_UNBIASED;
        public static final /* enum */ Type MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF;
        public static final /* enum */ Type NEAREST_EVEN_ORDER_STATISTICS;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        static {
            INVERSE_OF_EMPIRICAL_CDF = new Type();
            INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES = new Type();
            NEAREST_EVEN_ORDER_STATISTICS = new Type();
            LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF = new Type();
            MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF = new Type();
            MINITAB_SPSS = new Type();
            S = new Type();
            APPROXIMATELY_MEDIAN_UNBIASED = new Type();
            APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL = new Type();
            Type[] typeArray = new Type[9];
            typeArray[0] = INVERSE_OF_EMPIRICAL_CDF;
            typeArray[1] = INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES;
            typeArray[2] = NEAREST_EVEN_ORDER_STATISTICS;
            typeArray[3] = LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF;
            typeArray[4] = MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF;
            typeArray[5] = MINITAB_SPSS;
            typeArray[6] = S;
            typeArray[7] = APPROXIMATELY_MEDIAN_UNBIASED;
            typeArray[8] = APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL;
            $VALUES = typeArray;
        }

        private Type() {
            Type a2;
        }
    }
}

