/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.LogBeta;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class BetaDistribution
implements UnivariateDistribution {
    private static final LogBeta G = new LogBeta();
    private final BetaRegularizedInverse M;
    private final BetaRegularized m;
    public final double alpha;
    private static final Digamma H = new Digamma();
    public final double beta;

    public double entropy() {
        double a2 = G.evaluate(this.alpha, this.beta);
        a2 -= (this.alpha - 1.0) * H.evaluate(this.alpha);
        a2 -= (this.beta - 1.0) * H.evaluate(this.beta);
        return a2 += (this.alpha + this.beta - 2.0) * H.evaluate(this.alpha + this.beta);
    }

    public double quantile(double u2) {
        return this.M.evaluate(u2);
    }

    public double skew() {
        double a2 = this.alpha + this.beta;
        double a3 = 2.0 * (this.beta - this.alpha) * Math.sqrt(a2 + 1.0);
        return a3 /= (a2 + 2.0) * Math.sqrt(this.alpha * this.beta);
    }

    public BetaDistribution(double alpha, double beta) {
        SuanShuUtils.assertArgument(alpha > 0.0, b.C("dhvm`$op~p.gl$4%e"));
        SuanShuUtils.assertArgument(beta > 0.0, b.C("wqbt1ygfi4|p9*:e"));
        this.alpha = alpha;
        this.beta = beta;
        this.m = new BetaRegularized(alpha, beta);
        this.M = new BetaRegularizedInverse(alpha, beta);
    }

    public double variance() {
        double a2 = this.alpha + this.beta;
        double a3 = this.alpha * this.beta;
        return a3 /= a2 * a2 * (a2 + 1.0);
    }

    public double cdf(double x2) {
        assert (x2 >= 0.0) : b.C("l5zaca3vy5!)8e");
        assert (x2 <= 1.0) : b.C("l5zaca3vy5#)8d");
        return this.m.evaluate(x2);
    }

    public double median() {
        throw new UnsupportedOperationException(b.C("tt9yrtn\u007fv;wudv{"));
    }

    public double mean() {
        return this.alpha / (this.alpha + this.beta);
    }

    @Deprecated
    public double moment(double x2) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double density(double x2) {
        assert (x2 >= 0.0) : b.C("l5zaca3vy5!)8e");
        assert (x2 <= 1.0) : b.C("l5zaca3vy5#)8d");
        if (DoubleUtils.compare(x2, 0.0) == 0) {
            if (this.alpha < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        double a2 = (this.alpha - 1.0) * Math.log(x2) + (this.beta - 1.0) * Math.log(1.0 - x2) - G.evaluate(this.alpha, this.beta);
        a2 = Math.exp(a2);
        return a2;
    }

    public double ccdf(double x2) {
        return 1.0 - this.cdf(x2);
    }

    public double kurtosis() {
        double a2 = 6.0;
        a2 = 6.0 * (this.alpha * this.alpha * this.alpha - this.alpha * this.alpha * (2.0 * this.beta - 1.0) + this.beta * this.beta * (this.beta + 1.0) - 2.0 * this.alpha * this.beta * (this.beta + 2.0));
        return a2 /= this.alpha * this.beta * (this.alpha + this.beta + 2.0) * (this.alpha + this.beta + 3.0);
    }
}

