/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.GammaRegularizedP;
import com.numericalmethod.suanshu.analysis.function.special.GammaRegularizedPInverse;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class ChiSquareDistribution
implements UnivariateDistribution {
    private static final LogGamma G = new LogGamma();
    private static final GammaRegularizedP M = new GammaRegularizedP();
    public final double k;
    private static final Digamma m;
    private static final GammaRegularizedPInverse H;

    public ChiSquareDistribution(double k2) {
        SuanShuUtils.assertArgument(k2 > 0.0, b.C("r8wlnl>{t8,9e"));
        this.k = k2;
    }

    public double kurtosis() {
        return 12.0 / this.k;
    }

    public double entropy() {
        return this.k / 2.0 + Math.log(2.0) + G.evaluate(this.k / 2.0) + (1.0 - this.k / 2.0) * m.evaluate(this.k / 2.0);
    }

    public double variance() {
        return 2.0 * this.k;
    }

    public double quantile(double u2) {
        return 2.0 * H.evaluate(this.k / 2.0, u2);
    }

    public double median() {
        return this.k - 0.0 + 0.0 / this.k - 0.0 / this.k / this.k;
    }

    public double mean() {
        return this.k;
    }

    static {
        H = new GammaRegularizedPInverse();
        m = new Digamma();
    }

    public double density(double x2) {
        if (x2 < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.compare(x2, 0.0) == 0 && this.k < 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.compare(x2, 0.0) == 0 && this.k == 2.0) {
            return 0.5;
        }
        double a2 = Math.pow(0.5, this.k / 2.0);
        double a3 = (this.k / 2.0 - 1.0) * Math.log(x2) - x2 / 2.0 - G.evaluate(this.k / 2.0);
        return a2 *= Math.exp(a3);
    }

    public double moment(double t2) {
        SuanShuUtils.assertArgument(t2 < 0.5, b.C("zzzl1r}g=`>)9$4`"));
        return Math.pow(1.0 - 2.0 * t2, -this.k / 2.0);
    }

    public double skew() {
        return Math.sqrt(8.0 / this.k);
    }

    public double cdf(double x2) {
        assert (x2 >= 0.0) : b.C("l5zaca3vy5q{v8uqcts}v0");
        return M.evaluate(this.k / 2.0, x2 / 2.0);
    }
}

