/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.stats.descriptive.moment.Kurtosis;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.descriptive.moment.Skewness;
import com.numericalmethod.suanshu.stats.descriptive.moment.Variance;
import com.numericalmethod.suanshu.stats.descriptive.rank.Quantile;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;
import java.util.Arrays;

public class EmpiricalDistribution
implements UnivariateDistribution {
    private final double[] m;
    private final Quantile H;

    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double variance() {
        return new Variance(this.m, true).value();
    }

    public double mean() {
        return new Mean(this.m).value();
    }

    public double median() {
        return this.H.value(0.5);
    }

    public double cdf(double x2) {
        int a2;
        int a3 = 0;
        int n = a2 = 0;
        while (n < this.m.length && !(x2 < this.m[a2])) {
            ++a3;
            n = ++a2;
        }
        return (double)a3 / (double)this.m.length;
    }

    public double quantile(double u2) {
        return this.H.value(u2);
    }

    @Deprecated
    public double moment(double x2) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public EmpiricalDistribution(double[] data, Quantile.Type quantileType) {
        this.m = Arrays.copyOf(data, data.length);
        Arrays.sort(this.m);
        this.H = new Quantile(this.m, quantileType);
    }

    public double density(double x2) {
        int a2 = Arrays.binarySearch(this.m, 0, this.m.length, x2);
        int a3 = 0;
        if (a2 >= 0) {
            int a4;
            int n = a4 = a2;
            while (n < this.m.length && this.m[a4] == x2) {
                ++a3;
                n = ++a4;
            }
            int n2 = a4 = a2 - 1;
            while (n2 > 0 && this.m[a4] == x2) {
                ++a3;
                n2 = --a4;
            }
        }
        return (double)a3 / (double)this.m.length;
    }

    public EmpiricalDistribution(double[] data) {
        this(data, Quantile.Type.APPROXIMATELY_MEDIAN_UNBIASED);
    }

    public double skew() {
        return new Skewness(this.m).value();
    }

    public double kurtosis() {
        return new Kurtosis(this.m).value();
    }
}

