/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class ExponentialDistribution
implements UnivariateDistribution {
    public final double lambda;

    public double density(double x2) {
        double a2 = x2 < 0.0 ? 0.0 : this.lambda * Math.exp(-this.lambda * x2);
        return a2;
    }

    public double mean() {
        return 1.0 / this.lambda;
    }

    public ExponentialDistribution() {
        this(1.0);
    }

    public double kurtosis() {
        return 6.0;
    }

    public double moment(double t2) {
        double a2 = 1.0 - t2 / this.lambda;
        a2 = 1.0 / a2;
        return a2;
    }

    public double variance() {
        return 1.0 / this.lambda / this.lambda;
    }

    public ExponentialDistribution(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException(b.C("xtzvtt3*<e"));
        }
        this.lambda = lambda;
    }

    public double median() {
        return Math.log(2.0) / this.lambda;
    }

    public double quantile(double u2) {
        return -Math.log(1.0 - u2) / this.lambda;
    }

    public double cdf(double x2) {
        double a2 = x2 < 0.0 ? 0.0 : 1.0 - Math.exp(-this.lambda * x2);
        return a2;
    }

    public double entropy() {
        return 1.0 - Math.log(this.lambda);
    }

    public double skew() {
        return 2.0;
    }
}

