/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.LogBeta;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class FDistribution
implements UnivariateDistribution {
    private final BetaRegularizedInverse M;
    private final BetaRegularized m;
    public final double df1;
    private static final LogBeta H = new LogBeta();
    public final double df2;

    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double cdf(double x2) {
        SuanShuUtils.assertArgument(x2 >= 0.0, b.C("l5zaca3vy5!)8e"));
        return this.m.evaluate(this.df1 * x2 / (this.df1 * x2 + this.df2));
    }

    public double density(double x2) {
        SuanShuUtils.assertArgument(x2 >= 0.0, b.C("l5zaca3vy5!)8e"));
        if (DoubleUtils.compare(x2, 0.0) == 0) {
            if (this.df1 < 2.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.df1 == 2.0) {
                return 1.0;
            }
            return 0.0;
        }
        double a2 = this.df1 * Math.log(this.df1 * x2);
        a2 += this.df2 * Math.log(this.df2);
        a2 -= (this.df1 + this.df2) * Math.log(this.df1 * x2 + this.df2);
        a2 /= 2.0;
        a2 -= Math.log(x2);
        a2 -= H.evaluate(this.df1 / 2.0, this.df2 / 2.0);
        a2 = Math.exp(a2);
        return a2;
    }

    @Deprecated
    public double median() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double mean() {
        SuanShuUtils.assertOrThrow(this.df2 > 2.0 ? null : new UnsupportedOperationException(b.C("{{{m0ffdlzm`}q;rkg'pf'#*,g")));
        return this.df2 / (this.df2 - 2.0);
    }

    public double skew() {
        SuanShuUtils.assertOrThrow(this.df2 > 6.0 ? null : new UnsupportedOperationException(b.C("{{{m0ffdlzm`}q;rkg'pf'#*,c")));
        double a2 = (2.0 * this.df1 + this.df2 - 2.0) * Math.sqrt(8.0 * (this.df2 - 4.0));
        return a2 /= (this.df2 - 6.0) * Math.sqrt(this.df1 * (this.df1 + this.df2 - 2.0));
    }

    public FDistribution(double df1, double df2) {
        SuanShuUtils.assertArgument(df1 > 0.0, b.C("~}(:snnn2yt:(;e"));
        SuanShuUtils.assertArgument(df2 > 0.0, b.C("~}+:snnn2yt:(;e"));
        this.df1 = df1;
        this.df2 = df2;
        this.m = new BetaRegularized(df1 / 2.0, df2 / 2.0);
        this.M = new BetaRegularizedInverse(df1 / 2.0, df2 / 2.0);
    }

    public double quantile(double u2) {
        double a2 = this.M.evaluate(u2);
        return this.df2 * a2 / (this.df1 - this.df1 * a2);
    }

    public double kurtosis() {
        SuanShuUtils.assertOrThrow(this.df2 > 8.0 ? null : new UnsupportedOperationException(b.C("{{{m0ffdlzm`}q;rkg'pf'#*,m")));
        double a2 = 5.0 * this.df2 * this.df2 * this.df1 - 22.0 * this.df1 * this.df1 + 5.0 * this.df2 * this.df1 * this.df1 - 16.0;
        double a3 = 20.0 * this.df2 - 8.0 * this.df2 * this.df2 + this.df2 * this.df2 * this.df2 + 44.0 * this.df1 - 32.0 * this.df1 * this.df2 + a2;
        return (a3 /= this.df1 * (this.df2 - 6.0) * (this.df2 - 8.0) * (this.df1 + this.df2 - 2.0) / 12.0) - 3.0;
    }

    public double moment(double x2) {
        throw new UnsupportedOperationException(b.C("~t|i>urn2~iseo{"));
    }

    public double variance() {
        SuanShuUtils.assertOrThrow(this.df2 > 4.0 ? null : new UnsupportedOperationException(b.C("{{{m0ffdlzm`}q;rkg'pf'#*,a")));
        double a2 = 2.0 * this.df2 * this.df2 * (this.df1 + this.df2 - 2.0);
        return a2 /= this.df1 * (this.df2 - 2.0) * (this.df2 - 2.0) * (this.df2 - 4.0);
    }
}

