/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.GammaRegularizedP;
import com.numericalmethod.suanshu.analysis.function.special.GammaRegularizedPInverse;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class GammaDistribution
implements UnivariateDistribution {
    public final double theta;
    public final double k;
    private static final LogGamma M = new LogGamma();
    private static final GammaRegularizedPInverse m;
    private static final GammaRegularizedP H;

    public double moment(double t2) {
        SuanShuUtils.assertArgument(t2 < 1.0 / this.theta, b.C("zzzl1r}g=`>)9%5amqr4"));
        return Math.pow(1.0 - this.theta * t2, -this.k);
    }

    public GammaDistribution(double k2, double theta) {
        SuanShuUtils.assertArgument(k2 > 0.0, b.C("r8wlnl>{t8,9e"));
        SuanShuUtils.assertArgument(theta > 0.0, b.C("qlcq`$op~p.gl$4%e"));
        this.k = k2;
        this.theta = theta;
    }

    public double skew() {
        return 2.0 / Math.sqrt(this.k);
    }

    public double median() {
        throw new UnsupportedOperationException(b.C("^clxk+dy\"en*ubhzvn9irdnov+wedf{"));
    }

    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public double density(double x2) {
        if (x2 < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.compare(x2, 0.0) == 0 && this.k < 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.compare(x2, 0.0) == 0 && this.k == 1.0) {
            return Math.exp(-M.evaluate(this.k) - this.k * Math.log(this.theta));
        }
        double a2 = (this.k - 1.0) * Math.log(x2) - x2 / this.theta - this.k * Math.log(this.theta) - M.evaluate(this.k);
        a2 = Math.exp(a2);
        return a2;
    }

    public double quantile(double u2) {
        return this.theta * m.evaluate(this.k, u2);
    }

    public double variance() {
        return this.k * this.theta * this.theta;
    }

    public double mean() {
        return this.k * this.theta;
    }

    static {
        H = new GammaRegularizedP();
        m = new GammaRegularizedPInverse();
    }

    public double kurtosis() {
        return 6.0 / this.k;
    }

    public double cdf(double x2) {
        assert (x2 >= 0.0) : b.C("l5zaca3vy5q{v8uqcts}v0");
        return H.evaluate(this.k, x2 / this.theta);
    }
}

