/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.CumulativeNormal;
import com.numericalmethod.suanshu.analysis.function.special.CumulativeNormalInverse;
import com.numericalmethod.suanshu.analysis.function.special.Gaussian;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class NormalDistribution
implements UnivariateDistribution {
    public final double mu;
    private static CumulativeNormalInverse M;
    private static CumulativeNormal m;
    private static Gaussian H;
    public final double sigma;

    public double mean() {
        return this.mu;
    }

    public double cdf(double x2) {
        double a2 = (x2 - this.mu) / this.sigma;
        return m.evaluate(a2);
    }

    public double entropy() {
        return Math.log(Math.PI * 2 * this.sigma * this.sigma * Math.E);
    }

    public double median() {
        return this.mu;
    }

    static {
        H = new Gaussian();
        m = new CumulativeNormal();
        M = new CumulativeNormalInverse();
    }

    public double kurtosis() {
        return 0.0;
    }

    public double variance() {
        return this.sigma * this.sigma;
    }

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public double quantile(double u2) {
        double a2 = M.evaluate(u2);
        a2 = this.mu + this.sigma * a2;
        return a2;
    }

    public double skew() {
        return 0.0;
    }

    public NormalDistribution(double mu, double sigma) {
        this.mu = mu;
        this.sigma = sigma;
    }

    public double density(double x2) {
        double a2 = (x2 - this.mu) / this.sigma;
        double a3 = H.evaluate(a2);
        return a3 /= this.sigma;
    }

    public double moment(double t2) {
        double a2 = this.mu * t2;
        a2 += 0.5 * this.sigma * this.sigma * t2 * t2;
        a2 = Math.exp(a2);
        return a2;
    }
}

