/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.special.Erf;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class RayleighDistribution
implements UnivariateDistribution {
    public final double sigma;

    public double variance() {
        return this.sigma * this.sigma * 0.8584073464102069 / 2.0;
    }

    public double quantile(double u2) {
        return this.sigma * Math.sqrt(-2.0 * Math.log(1.0 - u2));
    }

    public double kurtosis() {
        return 0.18059727961888683 / Math.pow(0.8584073464102069, 2.0);
    }

    public double median() {
        return this.sigma * Math.sqrt(Math.log(4.0));
    }

    public RayleighDistribution(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException(b.C("vmah`$op~p.gl$4%e"));
        }
        this.sigma = sigma;
    }

    public double moment(double t2) {
        Erf a2 = new Erf();
        return 1.0 + this.sigma * t2 * Math.exp(this.sigma * this.sigma * t2 * t2 / 2.0) * Math.sqrt(1.5707963267948966) * (a2.evaluate(this.sigma * t2 / Constant.ROOT_2) + 1.0);
    }

    public double cdf(double x2) {
        assert (x2 >= 0.0) : b.C("l5zaca3vy5q{v8uqcts}v0");
        return 1.0 - Math.exp(-x2 * x2 / 2.0 / this.sigma / this.sigma);
    }

    public double mean() {
        return this.sigma * Math.sqrt(1.5707963267948966);
    }

    public double density(double x2) {
        assert (x2 >= 0.0) : b.C("l5zaca3vy5o{k|o}r0");
        return x2 / this.sigma / this.sigma * Math.exp(-x2 * x2 / 2.0 / this.sigma / this.sigma);
    }

    public double entropy() {
        return 1.0 + Math.log(this.sigma / Constant.ROOT_2) + 0.28860783245076643;
    }

    public double skew() {
        return 2.0 * Constant.ROOT_PI * 0.14159265358979312 / Math.pow(0.8584073464102069, 1.5);
    }
}

