/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.distribution.univariate;

import com.numericalmethod.suanshu.analysis.function.special.BetaRegularized;
import com.numericalmethod.suanshu.analysis.function.special.BetaRegularizedInverse;
import com.numericalmethod.suanshu.analysis.function.special.Digamma;
import com.numericalmethod.suanshu.analysis.function.special.LogBeta;
import com.numericalmethod.suanshu.analysis.function.special.LogGamma;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.UnivariateDistribution;

public class TDistribution
implements UnivariateDistribution {
    public final double v;
    private static final LogBeta B = new LogBeta();
    private final BetaRegularizedInverse G;
    private static final Digamma M;
    private static final LogGamma m;
    private final BetaRegularized H;

    public double mean() {
        SuanShuUtils.assertOrThrow(this.v > 1.0 ? null : new UnsupportedOperationException(b.C("{{{m0s|f<c?*8d")));
        return 0.0;
    }

    public double kurtosis() {
        SuanShuUtils.assertOrThrow(this.v > 4.0 ? null : new UnsupportedOperationException(b.C("{{{m0s|f<c?*8a")));
        return 6.0 / (this.v - 4.0);
    }

    public double variance() {
        SuanShuUtils.assertOrThrow(this.v >= 2.0 ? null : new UnsupportedOperationException(b.C("uuuc>}rh2m1$+;g")));
        if (this.v == 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.v / (this.v - 2.0);
    }

    public double entropy() {
        double a2 = (this.v + 1.0) / 2.0;
        a2 *= M.evaluate((1.0 + this.v) / 2.0) - M.evaluate(this.v / 2.0);
        return a2 += Math.log(Math.sqrt(this.v)) + B.evaluate(this.v / 2.0, 0.5);
    }

    public double quantile(double u2) {
        double a2 = this.G.evaluate(u2);
        double a3 = 0.25 / (a2 - 0.5) / (a2 - 0.5) / this.v - 1.0 / this.v;
        a3 = 1.0 / a3;
        a3 = Math.sqrt(a3);
        a3 = a2 - 0.5 > 0.0 ? a3 : -a3;
        return a3;
    }

    public TDistribution(double v) {
        SuanShuUtils.assertArgument(v > 0.0, b.C("{{{m0s|f<c?*8e"));
        this.v = v;
        this.H = new BetaRegularized(v / 2.0, v / 2.0);
        this.G = new BetaRegularizedInverse(v / 2.0, v / 2.0);
    }

    public double median() {
        return 0.0;
    }

    public double moment(double x2) {
        throw new UnsupportedOperationException(b.C("{{b5uqt|sqz{"));
    }

    public double skew() {
        SuanShuUtils.assertOrThrow(this.v > 3.0 ? null : new UnsupportedOperationException(b.C("{{{m0s|f<c?*8f")));
        return 0.0;
    }

    public double density(double x2) {
        if (DoubleUtils.compare(x2, 0.0) == 0) {
            return 0.0;
        }
        double a2 = m.evaluate((this.v + 1.0) / 2.0);
        a2 -= Math.log(Math.sqrt(this.v * Math.PI)) + m.evaluate(this.v / 2.0);
        a2 += -(this.v + 1.0) / 2.0 * Math.log(1.0 + x2 * x2 / this.v);
        a2 = Math.exp(a2);
        return a2;
    }

    public double cdf(double x2) {
        double a2 = x2;
        a2 /= 2.0 * Math.sqrt(x2 * x2 + this.v);
        return this.H.evaluate(a2 += 0.5);
    }

    static {
        m = new LogGamma();
        M = new Digamma();
    }
}

