/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.dlm.ObservationEquation;
import com.numericalmethod.suanshu.stats.dlm.StateEquation;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Dlm {
    private final ImmutableVector G;
    private final StateEquation M;
    final int d;
    private final ImmutableMatrix m;
    private final ObservationEquation H;
    final int p;

    public Dlm(Dlm that) {
        this(that.G, that.m, that.H, that.M);
    }

    public ImmutableMatrix C0() {
        return this.m;
    }

    public Dlm(Vector m0, Matrix C0, ObservationEquation Yt, StateEquation Xt) {
        SuanShuUtils.assertArgument(m0 != null && C0 != null, b.C("f{t2rzffhz{gjzr|\"|g2r{`2c}`fgra2AgPfS3MM\n3G2p;P\"\u000e3b\"\u000f3HgYg\tpK3^bwpxt\u007fv1"));
        this.p = m0.size();
        this.d = Yt.dimension();
        this.G = new ImmutableVector(m0);
        SuanShuUtils.assertArgument(C0.nRows() == this.p && C0.nCols() == this.p, b.C("a|s5u}\u007fpsgwzw4us%W65hg\"e-l.%"));
        this.m = new ImmutableMatrix(C0);
        SuanShuUtils.assertArgument(Yt.dimension() == this.d, b.C("`}r4t|~qrfv{v5tr$aoq zagigyu||dz\u0014pFaQaZ{R5Vg\u00181"));
        SuanShuUtils.assertArgument(Yt.F(1).nCols() == this.p, b.C("zgh.nfdkh|lal/nh>I=gi/}.n/%"));
        this.H = Yt;
        SuanShuUtils.assertArgument(Xt.dimension() == this.p, b.C("a|s5u}\u007fpsgwzw4us%`np!gvtyq.pxaka\\{X5Xg\u0012%"));
        this.M = Xt;
    }

    public int p() {
        return this.p;
    }

    public StateEquation getStateModel() {
        return this.M;
    }

    public ObservationEquation getObservationModel() {
        return this.H;
    }

    public int d() {
        return this.d;
    }

    public ImmutableVector m0() {
        return this.G;
    }
}

