/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.stats.dlm.Dlm;
import com.numericalmethod.suanshu.stats.dlm.ObservationEquation;
import com.numericalmethod.suanshu.stats.dlm.StateEquation;
import com.numericalmethod.suanshu.stats.random.multivariate.Gaussian;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.SimpleMultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class DlmSim {
    private final Matrix m;
    private final Matrix H;

    public DlmSim(int T2, Dlm model) {
        this(T2, model, null);
    }

    public DlmSim(int T2, Dlm model, MultiVariateTimeSeries Ut) {
        this.m = this.H(T2, model, Ut);
        this.H = this.H(this.m, model);
    }

    public SimpleMultiVariateTimeSeries getStates() {
        return new SimpleMultiVariateTimeSeries(this.m);
    }

    private DenseMatrix H(Matrix a2, Dlm a3) {
        int a4;
        ObservationEquation a5 = a3.getObservationModel();
        int a6 = a2.nRows();
        int a7 = a3.d();
        DenseMatrix a8 = new DenseMatrix(a6, a7);
        int n = a4 = 1;
        while (n <= a6) {
            Vector a9 = a5.yt(a4, a2.getRow(a4));
            a8.setRow(a4, a9);
            n = ++a4;
        }
        return a8;
    }

    private Matrix H(int a2, Dlm a3, MultiVariateTimeSeries a4) {
        int a5;
        StateEquation a6 = a3.getStateModel();
        int a7 = a3.p();
        DenseMatrix a8 = new DenseMatrix(a2, a7);
        double[] a9 = new Gaussian(a3.m0(), a3.C0()).nextVector();
        Vector a10 = a6.xt(1, new DenseVector(a9), a4 != null ? a4.get(1) : null);
        a8.setRow(1, a10);
        int n = a5 = 2;
        while (n <= a2) {
            a10 = a6.xt(a5, a8.getRow(a5 - 1), a4 != null ? a4.get(a5) : null);
            a8.setRow(a5, a10);
            n = ++a5;
        }
        return a8;
    }

    public SimpleMultiVariateTimeSeries getObservations() {
        return new SimpleMultiVariateTimeSeries(this.H);
    }
}

