/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.stats.dlm.Dlm;
import com.numericalmethod.suanshu.stats.dlm.ObservationEquation;
import com.numericalmethod.suanshu.stats.dlm.StateEquation;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.MultiVariateTimeSeries;
import com.numericalmethod.suanshu.stats.timeseries.multivariate.realtime.SimpleMultiVariateTimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class LinearKalmanFilter {
    private Matrix[] J;
    private Matrix[] C;
    private DenseMatrix F;
    private final Dlm B;
    private DenseMatrix G;
    private Matrix[] M;
    private DenseMatrix m;
    private Matrix[] H;

    public SimpleMultiVariateTimeSeries getFittedStates() {
        return new SimpleMultiVariateTimeSeries(this.m);
    }

    public LinearKalmanFilter(Dlm model) {
        this.B = model;
    }

    public SimpleMultiVariateTimeSeries getPredictedObservations() {
        return new SimpleMultiVariateTimeSeries(this.F);
    }

    public void filtering(MultiVariateTimeSeries Yt) {
        this.filtering(Yt, null);
    }

    public void filtering(MultiVariateTimeSeries Yt, MultiVariateTimeSeries Ut) {
        int a2;
        StateEquation a3 = this.B.getStateModel();
        ObservationEquation a4 = this.B.getObservationModel();
        int a5 = this.B.p();
        int a6 = this.B.d();
        int a7 = Yt.size();
        DenseMatrix a8 = new DenseMatrix(Yt.toMatrix());
        DenseMatrix a9 = Ut != null ? new DenseMatrix(Ut.toMatrix()) : null;
        this.G = new DenseMatrix(a7, a5);
        this.C = new DenseMatrix[a7];
        this.F = new DenseMatrix(a7, a6);
        this.J = new DenseMatrix[a7];
        this.H = new DenseMatrix[a7];
        this.m = new DenseMatrix(a7, a5);
        this.M = new DenseMatrix[a7];
        int n = a2 = 1;
        while (n <= a7) {
            ImmutableVector a10 = a2 > 1 ? this.m.getRow(a2 - 1) : this.B.m0();
            Vector a11 = a3.xt_mean(a2, a10, a9 != null ? a9.getRow(a2) : null);
            this.G.setRow(a2, a11);
            ImmutableMatrix a12 = a2 > 1 ? this.M[a2 - 2] : this.B.C0();
            Matrix a13 = a3.xt_var(a2, a12);
            this.C[a2 - 1] = a13;
            Vector a14 = a4.yt_mean(a2, a11);
            this.F.setRow(a2, a14);
            Matrix a15 = a4.yt_var(a2, a13);
            this.J[a2 - 1] = a15;
            Matrix a16 = a4.F(a2);
            this.H[a2 - 1] = new DenseMatrix(a13.multiply(a16.t()).multiply(new Inverse(a15)));
            Vector a17 = a8.getRow(a2).minus(a14);
            Vector a18 = a11.add(this.H[a2 - 1].multiply(a17));
            this.m.setRow(a2, a18);
            Matrix a19 = a13.minus(this.H[a2 - 1].multiply(a16).multiply(a13));
            this.M[a2 - 1] = a19;
            n = ++a2;
        }
    }
}

