/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm;

import com.numericalmethod.suanshu.analysis.function.matrix.R1toConstantMatrix;
import com.numericalmethod.suanshu.analysis.function.matrix.R1toMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.multivariate.Gaussian;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class ObservationEquation {
    private final R1toMatrix M;
    private final int m;
    private final R1toMatrix H;

    public Vector yt_mean(int t2, Vector xt) {
        return this.M.evaluate((double)t2).multiply(xt);
    }

    public ObservationEquation(R1toMatrix F2, R1toMatrix V) {
        this.m = F2.evaluate(1.0).nRows();
        SuanShuUtils.assertArgument(V.evaluate(1.0).nRows() == this.m && V.evaluate(1.0).nCols() == this.m, b.C("ZGH\u000eNFDKH\\LAL\u000fNH\u001ey\u001dGI\u000fMFS\u000fQG_J_]g@c\u000eeI)KgLm\u000emMrKlY|Zs@w\u000eop!"));
        this.M = F2;
        this.H = V;
    }

    public ObservationEquation(Matrix F2, Matrix V) {
        this(new R1toConstantMatrix(F2), new R1toConstantMatrix(V));
    }

    public Matrix yt_var(int t2, Matrix var_t_tlag) {
        Matrix a2 = this.F(t2);
        Matrix a3 = this.V(t2);
        return a2.multiply(var_t_tlag).multiply(a2.t()).add(a3);
    }

    public int dimension() {
        return this.m;
    }

    public ObservationEquation(ObservationEquation that) {
        this(that.M, that.H);
    }

    public Vector yt(int t2, Vector xt) {
        Vector a2 = this.yt_mean(t2, xt);
        Gaussian a3 = new Gaussian(new DenseVector(R.rep(0.0, this.m)), this.H.evaluate((double)t2));
        DenseVector a4 = new DenseVector(a3.nextVector());
        a2 = a2.add(a4);
        return a2;
    }

    public Matrix V(int t2) {
        return this.H.evaluate((double)t2);
    }

    public Matrix F(int t2) {
        return this.M.evaluate((double)t2);
    }
}

