/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.dlm;

import com.numericalmethod.suanshu.analysis.function.matrix.R1toConstantMatrix;
import com.numericalmethod.suanshu.analysis.function.matrix.R1toMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.multivariate.Gaussian;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class StateEquation {
    private final R1toMatrix G;
    private final R1toMatrix M;
    private final int m;
    private final R1toMatrix H;

    public StateEquation(R1toMatrix G, R1toMatrix H, R1toMatrix W) {
        this.m = G.evaluate(1.0).nRows();
        SuanShuUtils.assertArgument(W.evaluate(1.0).nRows() == this.m && W.evaluate(1.0).nCols() == this.m, b.C("UHG\u0001AIKDGSCNC\u0000AG\u0011w\u0012HF\u0000BI\\\u0000^HPEPRhOl\u0001jF&DhCb\u0001~ToUt\u0000j~!"));
        if (H != null) {
            SuanShuUtils.assertArgument(H.evaluate(1.0).nRows() == this.m, b.C("UHG\u0001AIKDGSCNC\u0000AG\u0011w\u0012HF\u0000BI\\\u0000^HPEPRhOl\u0001jF&DhCb\u0001~ToUt\u0000j~!"));
        }
        this.M = G;
        this.H = H;
        this.G = W;
    }

    public Matrix xt_var(int t2, Matrix var_tlag_tlag) {
        Matrix a2 = this.G(t2);
        Matrix a3 = this.W(t2);
        return a2.multiply(var_tlag_tlag).multiply(a2.t()).add(a3);
    }

    public int dimension() {
        return this.m;
    }

    public StateEquation(Matrix G, Matrix H, Matrix W) {
        this(new R1toConstantMatrix(G), H != null ? new R1toConstantMatrix(H) : null, new R1toConstantMatrix(W));
    }

    public StateEquation(Matrix G, Matrix W) {
        this(G, null, W);
    }

    public StateEquation(StateEquation that) {
        this(that.M, that.H, that.G);
    }

    public Vector xt_mean(int t2, Vector xt_1, Vector ut) {
        Vector a2 = this.M.evaluate((double)t2).multiply(xt_1);
        if (this.H != null) {
            Vector a3 = this.H.evaluate((double)t2).multiply(ut);
            a2 = a2.add(a3);
        }
        return a2;
    }

    public Vector xt_mean(int t2, Vector xt_1) {
        return this.xt_mean(t2, xt_1, null);
    }

    public Vector xt(int t2, Vector xt_1) {
        SuanShuUtils.assertArgument(this.H == null, b.C("j\u0003HQ\u0006MJV\nM\\NB\u0003LLV\u0003EJCP\u0015KN\u0003KGOVTPgP!VnF%AeM}PaO-TsQxCtO0"));
        return this.xt(t2, xt_1, null);
    }

    public Matrix G(int t2) {
        return this.M.evaluate((double)t2);
    }

    public Vector xt(int t2, Vector xt_1, Vector ut) {
        Vector a2 = this.xt_mean(t2, xt_1, ut);
        Gaussian a3 = new Gaussian(new DenseVector(R.rep(0.0, this.m)), this.G.evaluate((double)t2));
        DenseVector a4 = new DenseVector(a3.nextVector());
        a2 = a2.add(a4);
        return a2;
    }

    public StateEquation(R1toMatrix G, R1toMatrix W) {
        this(G, null, W);
    }

    public Matrix H(int t2) {
        return this.H != null ? this.H.evaluate((double)t2) : null;
    }

    public Matrix W(int t2) {
        return this.G.evaluate((double)t2);
    }
}

