/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.hmm;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class HiddenMarkovModel {
    private final Vector M;
    private final Matrix m;
    private final Matrix H;

    public ImmutableMatrix B() {
        return new ImmutableMatrix(this.m);
    }

    public HiddenMarkovModel(Vector PI, Matrix A, Matrix B) {
        int a2 = A.nRows();
        SuanShuUtils.assertArgument(PI.size() == a2, b.C("ZGH\u000eFJGIRG\u0005AD\u000fqg\u001e\\UAOC]\u000eTJ\u0015ZZJ\u0011]oBh\u000ek\\)ZnJ%@wBcKl\u000frH:\\mObJ&"));
        SuanShuUtils.assertArgument(A.nCols() == a2, b.C("O/~fezej&m`.c/r\u007fknok:bxzdf-"));
        SuanShuUtils.assertArgument(B.nRows() == a2, b.C("`}r4~`~vyg?{~5i{sf'{f5A4\u007f}`adq+vQ5C|U5@uQp\u001fuK5O|A5IaMwFf\fzI4[aJ`q&"));
        this.M = PI;
        this.H = A;
        this.m = B;
    }

    public int nStates() {
        return this.H.nRows();
    }

    public HiddenMarkovModel(HiddenMarkovModel that) {
        this.M = new DenseVector(that.M);
        this.H = new DenseMatrix(that.H);
        this.m = new DenseMatrix(that.m);
    }

    public ImmutableMatrix A() {
        return new ImmutableMatrix(this.H);
    }

    public HiddenMarkovModel(Matrix A, Matrix B) {
        this(new DenseVector(R.rep(1.0 / (double)A.nRows(), A.nRows())), A, B);
    }

    public int nSymbols() {
        return this.m.nCols();
    }

    public ImmutableVector PI() {
        return new ImmutableVector(this.M);
    }
}

