/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.distribution;

import com.numericalmethod.suanshu.stats.random.RNG;
import com.numericalmethod.suanshu.stats.random.RandomNumberGenerator;

public class Gaussian
implements RandomNumberGenerator {
    private final Method m;
    boolean next;
    double z2;
    public final double mu;
    private final RandomNumberGenerator H;
    double z1 = Double.NaN;
    public final double sigma;

    public Gaussian(double mu, double sigma) {
        this(mu, sigma, Method.BOX_MULLER, new RNG());
    }

    public synchronized double nextDouble() {
        if (!this.next) {
            this.generate();
            return this.mu + this.sigma * this.z1;
        }
        this.next = false;
        return this.mu + this.sigma * this.z2;
    }

    void generate() {
        Gaussian a2;
        if (a2.m == Method.BOX_MULLER) {
            a2.H();
        } else if (a2.m == Method.MARSAGLIA_BRAY) {
            a2.C();
        } else assert (false) : b.C("siwcahfhg}hb*jlr~h1");
        a2.next = true;
    }

    private void C() {
        double a2;
        double a3;
        double a4 = Double.MAX_VALUE;
        do {
            Gaussian a5;
            a3 = a5.H.nextDouble();
            a2 = a5.H.nextDouble();
        } while ((a4 = (a3 = 2.0 * a3 - 1.0) * a3 + (a2 = 2.0 * a2 - 1.0) * a2) > 1.0);
        double a6 = Math.sqrt(-2.0 * Math.log(a4) / a4);
        a5.z1 = a3 * a6;
        a5.z2 = a2 * a6;
    }

    public void seed(long ... seeds) {
        this.H.seed(seeds);
    }

    public Gaussian(double mu, double sigma, Method method, RandomNumberGenerator rng) {
        this.z2 = Double.NaN;
        this.mu = mu;
        this.sigma = sigma;
        this.m = method;
        this.H = rng;
        this.generate();
    }

    private void H() {
        Gaussian a2;
        double a3 = a2.H.nextDouble();
        double a4 = a2.H.nextDouble();
        double a5 = -2.0 * Math.log(a3);
        double a6 = Math.PI * 2 * a4;
        a2.z1 = Math.sqrt(a5) * Math.cos(a6);
        a2.z2 = Math.sqrt(a5) * Math.sin(a6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method BOX_MULLER = new Method();
        private static final /* synthetic */ Method[] $VALUES;
        public static final /* enum */ Method MARSAGLIA_BRAY = new Method();

        private Method() {
            Method a2;
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        static {
            Method[] methodArray = new Method[2];
            methodArray[0] = BOX_MULLER;
            methodArray[1] = MARSAGLIA_BRAY;
            $VALUES = methodArray;
        }
    }
}

