/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.multivariate;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.IsMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.Cholesky;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.RNG;
import com.numericalmethod.suanshu.stats.random.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.distribution.Gaussian;
import com.numericalmethod.suanshu.stats.random.distribution.StandardGaussian;
import com.numericalmethod.suanshu.stats.random.multivariate.IID;
import com.numericalmethod.suanshu.stats.random.multivariate.RandomVectorGenerator;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class Gaussian
implements RandomVectorGenerator {
    private final ImmutableMatrix G;
    private final int M;
    private final IID m;
    private final ImmutableVector H;

    public void seed(long ... seeds) {
        this.m.seed(seeds);
    }

    public Gaussian(Vector mu, Matrix sigma) {
        this(mu, sigma, new RNG(), SuanShuUtils.autoEpsilon(MatrixUtils.to1DArray(sigma)));
    }

    public Gaussian(Vector mu, Matrix sigma, RandomNumberGenerator rng, double epsilon) {
        Object a2;
        SuanShuUtils.assertArgument(sigma.nRows() == mu.size() && sigma.nCols() == mu.size(), b.C("e~r{s7b~qbqr:u|6g7vgwvss.zlbx~q6Yq\u0015r[zTxM~Rx\u001azL8U~_s\n>\u0001tW7@c\u0004d@ls?|"));
        this.M = mu.size();
        this.H = new ImmutableVector(mu);
        this.m = new IID(new StandardGaussian(Gaussian.Method.BOX_MULLER, rng), this.M);
        DenseMatrix a3 = new DenseMatrix(sigma);
        if (!IsMatrix.symmetricPositiveDefinite(sigma)) {
            int a4;
            a2 = new Eigen(sigma, Eigen.Method.QR, epsilon);
            Matrix a5 = ((Eigen)a2).Q();
            Matrix a6 = a5.t();
            DiagonalMatrix a7 = ((Eigen)a2).D();
            int n = a4 = 1;
            while (n < a7.nRows()) {
                if (a7.get(a4, a4) < epsilon) {
                    a7.set(a4, a4, epsilon);
                }
                n = ++a4;
            }
            a3 = new DenseMatrix(a5.multiply(a7).multiply(a6));
        }
        a2 = new Cholesky(a3);
        this.G = new ImmutableMatrix(((Cholesky)a2).L());
    }

    public double[] nextVector() {
        DenseVector a2 = new DenseVector(this.m.nextVector());
        return this.H.add(this.G.multiply(a2)).toArray();
    }
}

