/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.multivariate;

import com.numericalmethod.suanshu.stats.random.RNG;
import com.numericalmethod.suanshu.stats.random.RandomNumberGenerator;
import com.numericalmethod.suanshu.stats.random.multivariate.IID;
import com.numericalmethod.suanshu.stats.random.multivariate.RandomVectorGenerator;

public class Multinomial
implements RandomVectorGenerator {
    private final double[] M;
    private final int m;
    private final RandomNumberGenerator H;

    public Multinomial(int size, double[] prob, RandomNumberGenerator rng) {
        int a2;
        this.m = size;
        this.M = new double[prob.length];
        this.M[0] = prob[0];
        int n = a2 = 1;
        while (n < prob.length) {
            this.M[a2] = this.M[a2 - 1] + prob[a2];
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (n2 < prob.length) {
            int n3 = a2++;
            this.M[n3] = this.M[n3] / this.M[prob.length - 1];
            n2 = a2;
        }
        this.H = rng;
    }

    public Multinomial(int size, double[] prob) {
        this(size, prob, new RNG());
    }

    public double[] nextVector() {
        int a2;
        double[] a3 = new double[this.M.length];
        double[] a4 = new IID(this.H, this.m).nextVector();
        int n = a2 = 0;
        while (n < a4.length) {
            int a5;
            double a6 = a4[a2];
            int n2 = a5 = 0;
            while (n2 < this.M.length) {
                if (a6 < this.M[a5]) {
                    int n3 = a5;
                    a3[n3] = a3[n3] + 1.0;
                    break;
                }
                n2 = ++a5;
            }
            n = ++a2;
        }
        return a3;
    }

    public void seed(long ... seeds) {
        this.H.seed(seeds);
    }
}

