/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.pseudorandom;

import com.numericalmethod.suanshu.stats.random.RandomLongGenerator;

public class MersenneTwister
implements RandomLongGenerator {
    private static final int J = 624;
    private static final int[] C;
    private int[] F = new int[624];
    private static final int B = Integer.MAX_VALUE;
    private static final int G = 397;
    private static final int M = Integer.MIN_VALUE;
    private int m = 625;
    private static final int H = -1727483681;

    private long C(int a2) {
        return (long)a2 & Integer.MAX_VALUE | (a2 < 0 ? 0x80000000L : 0L);
    }

    private void H(long a2) {
        int a3;
        a.F[0] = (int)a2;
        long a4 = a2;
        int n = a3 = 1;
        while (true) {
            if (n >= 624) break;
            a4 = 1812433253L * (a4 ^ a4 >> 30) + (long)a3;
            a.F[a3] = (int)(a4 &= 0xFFFFFFFFL);
            n = ++a3;
        }
        a.m = 625;
    }

    public void seed(long ... seeds) {
        if (seeds.length == 1) {
            this.H(seeds[0]);
        } else {
            this.H(seeds);
        }
    }

    static {
        int[] nArray = new int[2];
        nArray[0] = 0;
        nArray[1] = -1727483681;
        C = nArray;
    }

    public double nextDouble() {
        return (double)this.nextLong() / 4.294967295E9;
    }

    public long nextLong() {
        int a2 = this.H(32);
        return this.C(a2);
    }

    private int H(int a2) {
        int a3;
        MersenneTwister a4;
        if (a4.m >= 624) {
            int a5;
            int n = a5 = 0;
            while (true) {
                if (n >= 227) break;
                a3 = a4.F[a5] & Integer.MIN_VALUE | a4.F[a5 + 1] & Integer.MAX_VALUE;
                a4.F[a5] = a4.F[a5 + 397] ^ a3 >>> 1 ^ C[a3 & 1];
                n = ++a5;
            }
            int n2 = a5 = 227;
            while (true) {
                if (n2 >= 623) break;
                a3 = a4.F[a5] & Integer.MIN_VALUE | a4.F[a5 + 1] & Integer.MAX_VALUE;
                a4.F[a5] = a4.F[a5 + -227] ^ a3 >>> 1 ^ C[a3 & 1];
                n2 = ++a5;
            }
            a3 = a4.F[623] & Integer.MIN_VALUE | a4.F[0] & Integer.MAX_VALUE;
            a4.F[623] = a4.F[396] ^ a3 >>> 1 ^ C[a3 & 1];
            a4.m = 0;
        }
        int n = a4.m;
        a4.m = n + 1;
        a3 = a4.F[n];
        a3 ^= a3 >>> 11;
        a3 = (int)((long)a3 ^ (long)(a3 << 7) & 0x9D2C5680L);
        a3 = (int)((long)a3 ^ (long)(a3 << 15) & 0xEFC60000L);
        a3 ^= a3 >>> 18;
        return a3 >>> 32 - a2;
    }

    public MersenneTwister() {
        long[] lArray = new long[1];
        lArray[0] = 8682522807148012L + System.nanoTime();
        this.seed(lArray);
    }

    private void H(long ... a2) {
        long a3;
        int a4;
        MersenneTwister a5;
        a5.H(19650218L);
        int a6 = 1;
        int a7 = 0;
        int n = a4 = Math.max(624, a2.length);
        while (n > 0) {
            a3 = (a5.C(a5.F[a6]) ^ (a5.C(a5.F[a6 - 1]) ^ a5.C(a5.F[a6 - 1]) >> 30) * 1664525L) + a2[a7] + (long)a7;
            a5.F[a6] = (int)(a3 & 0xFFFFFFFFL);
            ++a7;
            if (++a6 >= 624) {
                a5.F[0] = a5.F[623];
                a6 = 1;
            }
            if (a7 >= a2.length) {
                a7 = 0;
            }
            n = --a4;
        }
        int n2 = a4 = 623;
        while (n2 > 0) {
            a3 = (a5.C(a5.F[a6]) ^ (a5.C(a5.F[a6 - 1]) ^ a5.C(a5.F[a6 - 1]) >> 30) * 1566083941L) - (long)a6;
            a5.F[a6] = (int)(a3 & 0xFFFFFFFFL);
            if (++a6 >= 624) {
                a5.F[0] = a5.F[623];
                a6 = 1;
            }
            n2 = --a4;
        }
        a5.F[0] = Integer.MIN_VALUE;
        a5.m = 625;
    }

    public MersenneTwister(long ... seeds) {
        this.seed(seeds);
    }
}

