/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.pseudorandom.linear;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.pseudorandom.linear.LinearCongruentialGenerator;
import java.util.Arrays;

public class CombinedLinearCongruentialGenerator
implements LinearCongruentialGenerator {
    private LinearCongruentialGenerator[] m;
    private final long H;

    public int order() {
        int a2;
        int a3 = 0;
        LinearCongruentialGenerator[] a4 = this.m;
        int a5 = this.m.length;
        int n = a2 = 0;
        while (n < a5) {
            LinearCongruentialGenerator a6 = a4[a2];
            a3 += a6.order();
            n = ++a2;
        }
        return a3;
    }

    public void seed(long ... seeds) {
        int a2 = 0;
        int a3 = 0;
        int n = a2;
        while (n < this.m.length) {
            long[] a4 = Arrays.copyOfRange(seeds, a3, a3 + this.m[a2].order());
            this.m[a2].seed(a4);
            a3 += this.m[a2].order();
            n = ++a2;
        }
    }

    public CombinedLinearCongruentialGenerator(LinearCongruentialGenerator[] rng) {
        int a2;
        SuanShuUtils.assertArgument(rng.length > 0, b.C("gg*{lfjfl(elkmthmgh)jim)wggg1"));
        this.m = rng;
        long a3 = 0L;
        int n = a2 = 0;
        while (n < rng.length) {
            if (rng[a2].modulus() > a3) {
                a3 = rng[a2].modulus();
            }
            n = ++a2;
        }
        this.H = a3;
    }

    public long nextLong() {
        int a2;
        long a3 = 0L;
        int n = a2 = 0;
        while (n < this.m.length) {
            long a4 = this.m[a2].nextLong();
            a3 = a2 % 2 == 1 ? (a3 -= a4) : (a3 += a4);
            long l = a3;
            while (l < 0L) {
                l = a3 + this.H;
            }
            if (a3 > this.H) {
                a3 %= this.H;
            }
            n = ++a2;
        }
        return a3;
    }

    public long modulus() {
        return this.H;
    }

    public double nextDouble() {
        double a2;
        long a3 = this.nextLong();
        if (a3 > 0L) {
            a2 = (double)a3 / (double)(this.H - 1L);
        } else if (a3 == 0L) {
            a2 = (double)(this.H - 1L) / (double)this.H;
        } else {
            throw new RuntimeException(b.C("9cr:0-"));
        }
        return a2;
    }
}

