/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.pseudorandom.linear;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.pseudorandom.linear.LinearCongruentialGenerator;
import java.util.concurrent.atomic.AtomicLong;

public class Lehmer
implements LinearCongruentialGenerator {
    public final long q;
    private AtomicLong H = new AtomicLong();
    public final long m;
    public final long a;
    public final long r;

    public long modulus() {
        return this.m;
    }

    public Lehmer(long a2, long m, long k2, long seed) {
        this(FunctionOps.modpow(a2, k2, m), m, seed);
    }

    public void seed(long ... seeds) {
        this.H.set(seeds[0] % this.m);
    }

    public double nextDouble() {
        return (double)this.nextLong() / (double)this.m;
    }

    public Lehmer() {
        this(40014L, 2147483563L, 8682522807148012L + System.nanoTime());
    }

    public Lehmer(long a2, long m, long seed) {
        SuanShuUtils.assertArgument(a2 > 0L && m > 0L, b.C("t4w{u4\u007f5pama9v\u007f5u{u|u}t0"));
        this.a = a2;
        this.m = m;
        this.q = m / a2;
        this.r = m % a2;
        SuanShuUtils.assertArgument(this.r <= this.q, b.C("UHG\u0001\rA\n\u0001D\t\nBBMLH_AFHZN\u0016HJ\u0000TNI\u0000H@mIf\u001a%TtX)A*\u001d0\u0000}PcT:L|"));
        long[] lArray = new long[1];
        lArray[0] = seed;
        this.seed(lArray);
    }

    public int order() {
        return 1;
    }

    public long nextLong() {
        long a2;
        long a3;
        do {
            a2 = a3 = this.H.get();
            long a4 = a3 / this.q;
            if ((a2 = this.a * (a2 - a4 * this.q) - a4 * this.r) >= 0L) continue;
            a2 += this.m;
        } while (!this.H.compareAndSet(a3, a2));
        return a2;
    }
}

