/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.random.pseudorandom.linear;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.random.pseudorandom.linear.Lehmer;
import com.numericalmethod.suanshu.stats.random.pseudorandom.linear.LinearCongruentialGenerator;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MRG
implements LinearCongruentialGenerator {
    private Lehmer[] M;
    private long[] m;
    public final long m;
    private boolean[] H;

    public long modulus() {
        return this.m;
    }

    public MRG(long m, long ... a2) {
        int a3;
        this.m = null;
        this.m = m;
        this.M = new Lehmer[a2.length];
        this.H = new boolean[a2.length];
        int n = a3 = 0;
        while (n < a2.length) {
            if (a2[a3] != 0L) {
                this.M[a3] = new Lehmer(Math.abs(a2[a3]), m, 0L);
                this.H[a3] = a2[a3] > 0L;
            }
            n = ++a3;
        }
    }

    public long nextLong() {
        int a2;
        SuanShuUtils.assertOrThrow(this.m != null ? null : new RuntimeException(b.C("A\\S\u0015VQ\\POUJZK\u0014RTV\u0014HZU\u0014@PHZ\u000eFLQNP1")));
        long a3 = 0L;
        int n = a2 = this.M.length - 1;
        while (n >= 0) {
            if (this.M[a2] != null) {
                long l = a3 = this.H[a2] ? a3 + this.M[a2].nextLong() : a3 - this.M[a2].nextLong();
                while (l < 0L) {
                    l = a3 + this.m;
                }
                if (a3 > this.m) {
                    a3 %= this.m;
                }
            }
            n = --a2;
        }
        int n2 = a2 = this.M.length - 1;
        while (n2 >= 0) {
            long l = a2 == 0 ? a3 : (this.m[a2] = this.m[a2 - 1]);
            if (this.M[a2] != null) {
                long[] lArray = new long[1];
                lArray[0] = this.m[a2];
                this.M[a2].seed(lArray);
            }
            n2 = --a2;
        }
        return a3;
    }

    public void seed(long ... x2) {
        int a2;
        SuanShuUtils.assertArgument(x2.length == this.M.length, b.C("xbcl}obha,hxlng\u007f=cx-ji\u007fi&"));
        this.m = new long[x2.length];
        int n = a2 = 0;
        while (n < this.M.length) {
            this.m[a2] = x2[a2];
            if (this.M[a2] != null) {
                long[] lArray = new long[1];
                lArray[0] = x2[a2];
                this.M[a2].seed(lArray);
            }
            n = ++a2;
        }
    }

    public double nextDouble() {
        return (double)this.nextLong() / (double)this.m;
    }

    public int order() {
        return this.M.length;
    }
}

