/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear;

import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class LmProblem {
    public final ImmutableMatrix A;
    public final ImmutableVector wy;
    public final ImmutableVector weights;
    public final boolean addIntercept;
    public final ImmutableVector y;
    private volatile Matrix H = null;
    public final ImmutableMatrix wA;

    public LmProblem(Vector y2, Matrix X, boolean addIntercept) {
        this(y2, X, addIntercept, null);
    }

    public int nFactors() {
        return this.A.nCols();
    }

    protected void checkInputs() {
        SuanShuUtils.assertArgument(this.y.size() == this.A.nRows(), b.C("G\u001f\\P^\u001fx\u001eRP\u0015P]K\u0011VOIH\u001e^WL\u001eU^H[\u0002QTS|Zo\u001euY9LyH&"));
        if (this.weights != null) {
            int a2;
            SuanShuUtils.assertArgument(this.weights.size() == this.y.size(), b.C("RAOBIPQ\u0005LJJ\u0005P\u0004NJ\u0015JYQ\u0011LSSX\u0004JM\\\u0004IDhA&KtI`@\u007f\u0004aC)VeR&"));
            int n = a2 = 1;
            while (n <= this.weights.size()) {
                SuanShuUtils.assertArgument(this.weights.get(a2) >= 0.0, b.C("txz5fq{ru`m5taia%vc5o{l5cqit}}|0"));
                n = ++a2;
            }
        }
    }

    public LmProblem(Vector y2, Matrix X) {
        this(y2, X, true, null);
    }

    public LmProblem(Vector y2, Matrix X, Vector weights) {
        this(y2, X, true, weights);
    }

    public int nObs() {
        return this.A.nRows();
    }

    static {
        Package.getInstance(b.C("BDSE\u0006")).validate();
    }

    public int nExogenousFactors() {
        return this.A.nCols() - (this.addIntercept ? 1 : 0);
    }

    public LmProblem(LmProblem that) {
        this.y = new ImmutableVector(that.y);
        this.A = new ImmutableMatrix(that.A);
        this.wy = new ImmutableVector(that.wy);
        this.wA = new ImmutableMatrix(that.wA);
        this.addIntercept = that.addIntercept;
        this.weights = that.weights == null ? null : new ImmutableVector(that.weights);
    }

    public Matrix X() {
        return !this.addIntercept ? this.A : CreateMatrix.subMatrix(this.A, 1, this.A.nRows(), 1, this.A.nCols() - 1);
    }

    public LmProblem(Vector y2, Matrix X, boolean addIntercept, Vector weights) {
        Matrix matrix;
        this.y = !(y2 instanceof ImmutableVector) ? new ImmutableVector(y2) : (ImmutableVector)y2;
        this.addIntercept = addIntercept;
        if (!addIntercept) {
            matrix = X;
        } else {
            Matrix[] matrixArray = new Matrix[2];
            matrixArray[0] = X;
            matrixArray[1] = new DenseMatrix(R.rep(1.0, X.nRows()), X.nRows(), 1);
            matrix = CreateMatrix.cbind(matrixArray);
        }
        this.A = new ImmutableMatrix(matrix);
        ImmutableVector immutableVector = weights != null ? (!(weights instanceof ImmutableVector) ? new ImmutableVector(weights) : (ImmutableVector)weights) : (this.weights = null);
        if (weights != null) {
            Vector a2 = weights.pow(0.5);
            DiagonalMatrix a3 = new DiagonalMatrix(a2.toArray());
            this.wA = new ImmutableMatrix(a3.multiply(this.A));
            this.wy = new ImmutableVector(y2.multiply(a2));
        } else {
            this.wA = this.A;
            this.wy = this.y;
        }
        this.checkInputs();
    }

    public Matrix invOfwAtwA() {
        if (this.H == null) {
            this.H = new Inverse(this.wA.t().multiply(this.wA));
        }
        return this.H;
    }
}

