/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm;

import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GlmProblem;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class Residuals
extends com.numericalmethod.suanshu.stats.regression.linear.Residuals {
    public final double overdispersion;
    public final ImmutableVector devianceResiduals;
    protected final double[] deviances;
    public final double deviance;

    public double overdispersion() {
        return ((GlmProblem)this.problem).family.dispersion(this.problem.y, this.fitted, this.problem.nFactors());
    }

    protected Residuals(GlmProblem problem, Vector fitted) {
        super(problem, fitted);
        int a2;
        int a3 = problem.nObs();
        this.deviances = this.deviances();
        this.deviance = DoubleUtils.sum(this.deviances);
        this.overdispersion = this.overdispersion();
        double[] a4 = new double[a3];
        int n = a2 = 0;
        while (n < a3) {
            a4[a2] = this.residuals.get(a2 + 1) > 0.0 ? Math.sqrt(this.deviances[a2]) : -Math.sqrt(this.deviances[a2]);
            n = ++a2;
        }
        this.devianceResiduals = new ImmutableVector(new DenseVector(a4));
    }

    public double[] deviances() {
        int a2;
        int a3 = this.problem.nObs();
        GlmProblem a4 = (GlmProblem)this.problem;
        double[] a5 = new double[a3];
        int n = a2 = 1;
        while (n <= a3) {
            a5[a2 - 1] = a4.family.deviance(this.problem.y.get(a2), this.fitted.get(a2));
            n = ++a2;
        }
        return a5;
    }
}

