/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.LinkFunction;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.Logit;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Binomial
extends Family {
    private final int H = 1;

    public double deviance(double y2, double mu) {
        return 2.0 * (this.H(y2, mu) + this.H(1.0 - y2, 1.0 - mu));
    }

    public double overdispersion(Vector y2, Vector mu, int nFactors) {
        int a2;
        int a3 = y2.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += Math.pow(y2.get(a2) - mu.get(a2), 2.0) / this.variance(mu.get(a2));
            n = ++a2;
        }
        return a4 /= (double)(a3 - nFactors);
    }

    private double H(double a2, double a3) {
        return a2 == 0.0 ? 0.0 : a2 * Math.log(Math.abs(a2 / a3));
    }

    public Binomial(LinkFunction link) {
        super(link);
    }

    public double cumulant(double theta) {
        return Math.log(1.0 + Math.exp(theta));
    }

    public Binomial() {
        this(new Logit());
    }

    public double dispersion(Vector y2, Vector mu, int nFactors) {
        return 1.0;
    }

    public double AIC(Vector y2, Vector mu, Vector weight, double prelogLike, double deviance, int nFactors) {
        double a2 = prelogLike;
        return 2.0 * ((double)nFactors - a2);
    }

    public double variance(double mu) {
        return mu * (1.0 - mu);
    }

    public double theta(double mu) {
        return Math.log(Math.abs(mu / (1.0 - mu)));
    }
}

