/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.analysis.function.special.LogGamma;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.Inverse;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.LinkFunction;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Gamma
extends Family {
    public Gamma(LinkFunction link) {
        super(link);
    }

    public double overdispersion(Vector y2, Vector mu, int nFactors) {
        int a2;
        int a3 = y2.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += Math.pow(y2.get(a2) / mu.get(a2) - 1.0, 2.0);
            n = ++a2;
        }
        return a4 /= (double)(a3 - nFactors);
    }

    public double deviance(double y2, double mu) {
        return 2.0 * (-Math.log(y2 == 0.0 ? 1.0 : Math.abs(y2 / mu)) + (y2 - mu) / mu);
    }

    public Gamma() {
        this(new Inverse());
    }

    public double AIC(Vector y2, Vector mu, Vector weight, double prelogLike, double deviance, int nFactors) {
        int a2;
        int a3 = y2.size();
        double a4 = deviance / (double)a3;
        LogGamma a5 = new LogGamma();
        double a6 = prelogLike / a4;
        double a7 = 1.0 / a4;
        int n = a2 = 1;
        while (n <= a3) {
            a6 += a7 * Math.log(a7 * y2.get(a2)) - Math.log(y2.get(a2)) - a5.evaluate(a7);
            n = ++a2;
        }
        return 2.0 * ((double)(nFactors + 1) - a6);
    }

    public double cumulant(double theta) {
        return -Math.log(Math.abs(-theta));
    }

    public double dispersion(Vector y2, Vector mu, int nFactors) {
        return this.overdispersion(y2, mu, nFactors);
    }

    public double variance(double mu) {
        return mu * mu;
    }

    public double theta(double mu) {
        return -1.0 / mu;
    }
}

