/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.Identity;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.LinkFunction;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Gaussian
extends Family {
    public Gaussian(LinkFunction link) {
        super(link);
    }

    public double deviance(double y2, double mu) {
        double a2 = y2 - mu;
        return a2 * a2;
    }

    public double variance(double mu) {
        return 1.0;
    }

    public Gaussian() {
        this(new Identity());
    }

    public double AIC(Vector y2, Vector mu, Vector weight, double preLogLike, double deviance, int nFactors) {
        int a2;
        int a3 = y2.size();
        double a4 = deviance / (double)a3;
        double a5 = preLogLike / a4 - (double)a3 * Math.log(Math.PI * 2 * a4) / 2.0;
        int n = a2 = 1;
        while (n <= a3) {
            a5 += -0.5 * Math.pow(y2.get(a2), 2.0) / a4;
            n = ++a2;
        }
        return 2.0 * ((double)(nFactors + 1) - a5);
    }

    public double cumulant(double theta) {
        return theta * theta / 2.0;
    }

    public double dispersion(Vector y2, Vector mu, int nFactors) {
        return this.overdispersion(y2, mu, nFactors);
    }

    public double overdispersion(Vector y2, Vector mu, int nFactors) {
        int a2;
        int a3 = y2.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += Math.pow(y2.get(a2) - mu.get(a2), 2.0);
            n = ++a2;
        }
        return a4 /= (double)(a3 - nFactors);
    }

    public double theta(double mu) {
        return mu;
    }
}

