/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.InverseSquared;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.LinkFunction;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class InverseGaussian
extends Family {
    public double cumulant(double theta) {
        return -Math.sqrt(-2.0 * theta);
    }

    public double deviance(double y2, double mu) {
        double a2 = y2 - mu;
        return a2 * a2 / (y2 * mu * mu);
    }

    public double AIC(Vector y2, Vector mu, Vector weight, double prelogLike, double deviance, int nFactors) {
        int a2;
        int a3 = y2.size();
        double a4 = deviance / (double)a3;
        double a5 = prelogLike / a4 - (double)a3 * Math.log(Math.PI * 2 * a4) / 2.0;
        int n = a2 = 1;
        while (n <= a3) {
            a5 += -(3.0 * Math.log(y2.get(a2)) + 1.0 / (a4 * y2.get(a2))) / 2.0;
            n = ++a2;
        }
        return 2.0 * ((double)(nFactors + 1) - a5);
    }

    public double variance(double mu) {
        return mu * mu * mu;
    }

    public InverseGaussian(LinkFunction link) {
        super(link);
    }

    public InverseGaussian() {
        this(new InverseSquared());
    }

    public double overdispersion(Vector y2, Vector mu, int nFactors) {
        int a2;
        int a3 = y2.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += Math.pow((y2.get(a2) - mu.get(a2)) / Math.pow(mu.get(a2), 1.5), 2.0);
            n = ++a2;
        }
        return a4 /= (double)(a3 - nFactors);
    }

    public double theta(double mu) {
        return -1.0 / (2.0 * mu * mu);
    }

    public double dispersion(Vector y2, Vector mu, int nFactors) {
        return this.overdispersion(y2, mu, nFactors);
    }
}

