/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.distribution;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.LinkFunction;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.link.Log;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Poisson
extends Family {
    public Poisson(LinkFunction link) {
        super(link);
    }

    public double cumulant(double theta) {
        return Math.exp(theta);
    }

    public double AIC(Vector y2, Vector mu, Vector weight, double preLogLike, double deviance, int nFactors) {
        int a2;
        int a3 = y2.size();
        double a4 = preLogLike;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += -Math.log(FunctionOps.factorial((int)y2.get(a2)));
            n = ++a2;
        }
        return 2.0 * ((double)nFactors - a4);
    }

    public double dispersion(Vector y2, Vector mu, int nFactors) {
        return 1.0;
    }

    public double variance(double mu) {
        return mu;
    }

    public double deviance(double y2, double mu) {
        return 2.0 * (y2 * Math.log(y2 == 0.0 ? 1.0 : Math.abs(y2 / mu)) - y2 + mu);
    }

    public Poisson() {
        this(new Log());
    }

    public double theta(double mu) {
        return Math.log(mu);
    }

    public double overdispersion(Vector y2, Vector mu, int nFactors) {
        int a2;
        int a3 = y2.size();
        double a4 = 0.0;
        int n = a2 = 1;
        while (n <= a3) {
            a4 += Math.pow(y2.get(a2) - mu.get(a2), 2.0) / this.variance(mu.get(a2));
            n = ++a2;
        }
        return a4 /= (double)(a3 - nFactors);
    }
}

