/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.quasi;

import com.numericalmethod.suanshu.stats.regression.linear.glm.IWLS;
import com.numericalmethod.suanshu.stats.regression.linear.glm.quasi.Beta;
import com.numericalmethod.suanshu.stats.regression.linear.glm.quasi.NewtonRaphson;
import com.numericalmethod.suanshu.stats.regression.linear.glm.quasi.QuasiGlmProblem;
import com.numericalmethod.suanshu.stats.regression.linear.glm.quasi.Residuals;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class GeneralizedLinearModelQuasiFamily {
    public final Beta beta;
    public final QuasiGlmProblem problem;
    public final Residuals residuals;

    public GeneralizedLinearModelQuasiFamily(QuasiGlmProblem problem) {
        this.problem = problem;
        IWLS a2 = new IWLS(0.0, 1);
        a2.fit(problem, new DenseVector(problem.nFactors(), 1.0E-4));
        ImmutableVector a3 = a2.betaHat();
        NewtonRaphson a4 = new NewtonRaphson(1.0E-9, 100);
        a4.fit(problem, a3);
        this.residuals = new Residuals(problem, (Vector)a4.mu());
        this.beta = new Beta(a4, this.residuals);
    }
}

