/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.glm.quasi;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.stats.regression.linear.glm.Fitting;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GlmProblem;
import com.numericalmethod.suanshu.stats.regression.linear.glm.distribution.Family;
import com.numericalmethod.suanshu.stats.regression.linear.glm.quasi.QuasiGlmProblem;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

class NewtonRaphson
implements Fitting {
    final int maxIterations;
    final double threshold;
    private Run H;

    public void fit(GlmProblem problem, Vector beta0Initial) {
        if (!(problem instanceof QuasiGlmProblem)) {
            throw new RuntimeException(b.C("`}r4`g|vppr4qf;zka'geavd,s`f(d~uG|\u0017S|\u0018"));
        }
        this.H = new Run((QuasiGlmProblem)problem, beta0Initial);
    }

    public ImmutableMatrix DVInv() {
        return new ImmutableMatrix(this.H.m);
    }

    public ImmutableVector mu() {
        return new ImmutableVector(this.H.G);
    }

    NewtonRaphson(double a2, int a3) {
        NewtonRaphson a4;
        a4.threshold = a2;
        a4.maxIterations = a3;
    }

    public ImmutableMatrix D() {
        return new ImmutableMatrix(this.H.F);
    }

    public double logLikelihood() {
        return this.H.H;
    }

    public ImmutableVector weights() {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public ImmutableVector betaHat() {
        return new ImmutableVector(this.H.M);
    }

    private class Run {
        private Matrix F;
        private final QuasiGlmProblem B;
        private Vector G;
        private Vector M;
        private Matrix m;
        private double H = Double.POSITIVE_INFINITY;

        private void H() {
            Run a2;
            int a3 = a2.B.nObs();
            int a4 = a2.M.size();
            Family a5 = a2.B.quasiFamily.asFamily();
            a2.G = new DenseVector(a3);
            a2.F = new DenseMatrix(a3, a4);
            Vector a6 = new DenseVector(a4);
            boolean a7 = false;
            boolean bl = a7;
            for (int a8 = 0; !bl && a8 < a2.NewtonRaphson.this.maxIterations; ++a8) {
                int a9;
                int a10;
                int a11;
                Vector a12 = a2.B.A.multiply(a2.M);
                int n = a11 = 1;
                while (n <= a3) {
                    double a13 = a5.link().inverse(a12.get(a11));
                    a2.G.set(a11, a13);
                    int n2 = a10 = 1;
                    while (n2 <= a4) {
                        a2.F.set(a11, a10, a2.B.A.get(a11, a10) / a5.link().derivative(a13));
                        n2 = ++a10;
                    }
                    n = ++a11;
                }
                DiagonalMatrix a22 = new DiagonalMatrix(a3);
                int n3 = a9 = 1;
                while (n3 <= a3) {
                    a22.set(a9, a9, 1.0 / a5.variance(a2.G.get(a9)));
                    n3 = ++a9;
                }
                a2.m = a2.F.t().multiply(a22);
                ImmutableVector a32 = new ImmutableVector(a2.B.y.minus(a2.G));
                Vector a14 = new Inverse(a2.m.multiply(a2.F)).multiply(a2.m).multiply(a32);
                a6 = a2.M.add(a14);
                double a15 = 0.0;
                int n4 = a10 = 1;
                while (n4 <= a3) {
                    a15 += a2.B.quasiFamily.quasiLikelihood(a2.G.get(a10), a2.B.y.get(a10));
                    n4 = ++a10;
                }
                a7 = a2.M != null ? a6.minus(a2.M).norm() < a2.NewtonRaphson.this.threshold : false;
                a2.H = a15;
                a2.M = a6;
                bl = a7 |= Math.abs(a15 - a2.H) < a2.NewtonRaphson.this.threshold;
            }
        }

        private Run(QuasiGlmProblem a2, Vector a3) {
            Run a4;
            a4.B = a2;
            a4.M = a3;
            a4.H();
        }
    }
}

