/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.logistic;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMaximizer;
import com.numericalmethod.suanshu.stats.regression.linear.LmProblem;
import com.numericalmethod.suanshu.stats.regression.linear.logistic.Beta;
import com.numericalmethod.suanshu.stats.regression.linear.logistic.LogLikelihood;
import com.numericalmethod.suanshu.stats.regression.linear.logistic.LogisticProblem;
import com.numericalmethod.suanshu.stats.regression.linear.logistic.Residuals;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class Logistic {
    public final Beta beta;
    public final LogisticProblem problem;
    public final double ML;
    public final Residuals residuals;
    public final double AIC;

    public Logistic(LmProblem problem) {
        this.problem = new LogisticProblem(problem);
        int a2 = problem.nFactors();
        RealScalarFunction a3 = new LogLikelihood().function(this.problem);
        UnconstrainedMaximizer a4 = new UnconstrainedMaximizer();
        a4.solve(a3, 1.0E-10);
        double[] a5 = a4.search(200, R.rep(0.0, a2));
        this.ML = a3.evaluate(a5);
        DenseVector a6 = new DenseVector(a5);
        this.residuals = new Residuals(this.problem, (Vector)a6);
        this.beta = new Beta((Vector)a6, this.residuals);
        this.AIC = (double)(2 * a2) - 2.0 * this.ML;
    }
}

