/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.modelselection;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.distribution.univariate.NormalDistribution;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GeneralizedLinearModel;
import com.numericalmethod.suanshu.stats.regression.linear.glm.GlmProblem;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.Arrays;

abstract class SingleFactorSelection {
    public final GlmProblem problem;
    Indices indices;
    public final double criticalValue;

    public GeneralizedLinearModel model() {
        Matrix a2 = this.indices.subA();
        if (a2 == null) {
            throw new ModelNotFound(b.C("zz7rqvg{n5lqtpx`a1"));
        }
        GlmProblem a3 = new GlmProblem((Vector)this.problem.y, a2, this.problem.addIntercept, this.problem.family);
        return new GeneralizedLinearModel(a3);
    }

    public SingleFactorSelection(GlmProblem problem, double significance) {
        SuanShuUtils.assertArgument(significance < 0.5, b.C("NUYSPZS^TRB\u001d]YDXA\u001c]UFIFY\u0005^C\u001dMYQN=Hv\\w\u001c*\u0013`"));
        this.problem = problem;
        this.criticalValue = new NormalDistribution(0.0, 1.0).quantile(1.0 - significance / 2.0);
    }

    int[] factors() {
        SingleFactorSelection a2;
        return Arrays.copyOf(a2.indices.flags, a2.indices.flags.length);
    }

    class Indices {
        protected final GlmProblem problem;
        protected int[] flags;
        protected int[] subset;

        boolean isSelected(int a2) {
            Indices a3;
            return a3.flags[a2 - 1] > 0;
        }

        Indices(GlmProblem a2) {
            Indices a3;
            a3.problem = a2;
        }

        Matrix subA() {
            Indices a2;
            a2.subset = R.select(a2.flags, new R.which(){
                {
                    1 a2;
                }

                public boolean isTrue(double x2, int index) {
                    return x2 > 0.0;
                }
            });
            DenseMatrix a3 = a2.subset.length > 0 ? CreateMatrix.columns(a2.problem.A, a2.subset) : null;
            return a3;
        }
    }

    public static class ModelNotFound
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ModelNotFound(String msg) {
            super(msg);
        }
    }
}

