/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.regression.linear.ols;

import com.numericalmethod.suanshu.matrix.doubles.linearsystem.OLSSolver;
import com.numericalmethod.suanshu.stats.regression.linear.LmProblem;
import com.numericalmethod.suanshu.stats.regression.linear.ols.Beta;
import com.numericalmethod.suanshu.stats.regression.linear.ols.Diagnostics;
import com.numericalmethod.suanshu.stats.regression.linear.ols.InformationCriteria;
import com.numericalmethod.suanshu.stats.regression.linear.ols.Residuals;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class OlsRegression {
    public final Residuals residuals;
    public final InformationCriteria informationCriteria;
    public final Beta beta;
    public final LmProblem problem;
    public final Diagnostics diagnostics;

    public OlsRegression(LmProblem problem) {
        this.problem = problem;
        Vector a2 = new OLSSolver(problem.wA).solve(problem.wy);
        this.residuals = new Residuals(problem, a2);
        this.beta = new Beta(a2, this.residuals);
        this.diagnostics = new Diagnostics(this.residuals);
        this.informationCriteria = new InformationCriteria(this.residuals);
    }
}

