/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.stochasticprocess.multivariate.sde;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.stats.stochasticprocess.multivariate.sde.Ft;
import com.numericalmethod.suanshu.stats.stochasticprocess.multivariate.sde.SDE;
import com.numericalmethod.suanshu.stats.stochasticprocess.multivariate.sde.coefficients.Diffusion;
import com.numericalmethod.suanshu.stats.stochasticprocess.multivariate.sde.coefficients.Drift;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class Bessel
extends SDE {
    public final int d;

    public Bessel(final int d2) {
        super(new Drift(){
            {
                1 a2;
            }

            public Vector evaluate(Ft ft) {
                double[] dArray = new double[1];
                dArray[0] = d2;
                return new DenseVector(dArray);
            }
        }, new Sigma(d2), d2);
        this.d = d2;
    }

    private static class Sigma
    implements Diffusion {
        private final int m;
        private Vector H;

        public int ncols() {
            return this.m;
        }

        private Sigma(int a2) {
            Sigma a3;
            a3.m = a2;
            a3.H = new DenseVector(a2, 0.0);
        }

        public Matrix evaluate(Ft ft) {
            Matrix a2 = new DenseMatrix(this.H.toArray(), 1, this.m);
            a2 = a2.scaled(2.0);
            this.H = this.H.add(ft.dWt());
            return a2;
        }

        public int nrows() {
            return 1;
        }
    }
}

